<?php
/**
	Register Shortcode
**/
if( !function_exists('vcex_bullets_shortcode') ) {
	function vcex_bullets_shortcode( $atts, $content = NULL ) {
		extract( shortcode_atts( array(
			'style'	=> ''
		),
		$atts ) );
		return '<div class="vcex-bullets vcex-bullets-' . $style . '">' . do_shortcode( $content ) . '</div>';
	}
}
add_shortcode('vcex_bullets', 'vcex_bullets_shortcode');



/**
	Add To Visual Composer
**/
vc_map( array(
	"name"					=> __( "Bullets", 'vcex' ),
	"description"			=> __( "Styled bulleted lists", 'vcex' ),
	"base"					=> "vcex_bullets",
	"category"				=> __('Content', 'js_composer'),
	"icon"					=> "icon-wpb-vcex-bullets",
	"params"				=> array(
		array(
			"type"			=> "textarea_html",
			"heading"		=> __( "List", 'vcex' ),
			"param_name"	=> "content",
			"value"			=> "<ul><li>List 1</li><li>List 2</li><li>List 3</li><li>List 4</li></ul>",
			"description"	=> __( "Insert your unordered list here.", 'vcex' )
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Style", 'vcex' ),
			"param_name"	=> "style",
			"admin_label"	=> true,
			"value"			=> array(
				__( "Check", "vcex")	=> "check",
				__( "Blue", "vcex" )	=> "blue",
				__( "Gray", "vcex" )	=> "gray",
				__( "Purple", "vcex" )	=> "purple",
				__( "Red", "vcex" )		=> "red",
			),
			"description"	=> __( "Select your bullet style.", 'vcex' )
		),
	)
) );
?>