<?php
/**
	Register Shortcode
**/
if( !function_exists('vcex_callout_shortcode') ) {
	function vcex_callout_shortcode( $atts, $content = NULL  ) {
		extract( shortcode_atts( array(
			'caption'				=> '',
			'button_text'			=> '',
			'button_style'			=> 'graphical',
			'button_color'			=> 'blue',
			'button_url'			=> 'http://www.wpexplorer.com',
			'button_rel'			=> 'nofollow',
			'button_target'			=> 'blank',
			'button_border_radius'	=> '',
			'button_title'			=> __('Visit Site', 'vcex' ),
			'button_icon_left'		=> '',
			'button_icon_right'		=> '',
			'css_animation'			=> '',
		), $atts ) );
		
		// CSS animation Class
		$css_animation_classes='';
		if ( $css_animation !== '' ) {
			$css_animation_classes = 'wpb_animate_when_almost_visible wpb_'. $css_animation .'';
		}
		
		//Set Vars
		$button_border_radius = ( $button_border_radius ) ? 'style="border-radius:'. $button_border_radius .'"' : NULL;		
		$button_rel = ( $button_rel !== 'none' ) ? 'rel="'.$button_rel.'"' : NULL;
		
		// Display Callout
		$output = '<div class="vcex-callout vcex-clearfix '. $css_animation_classes .'">';
		$output .= '<div class="vcex-callout-caption">';
			$output .= do_shortcode ( $content );
		$output .= '</div>';	
		if ( $button_text !== '' ) {
			$output .= '<div class="vcex-callout-button">';
				$output .= '<a href="' . $button_url . '" class="vcex-button '. $button_style .' ' . $button_color . '" target="_'.$button_target.'" title="'. $button_text .'" '. $button_border_radius .' '. $button_rel .'>';
					$output.= '<span class="vcex-button-inner" '.$button_border_radius.'>';
						if ( $button_icon_left && $button_icon_left !== 'none' ) $output.= '<i class="vcex-button-icon-left fa fa-'. $button_icon_left .'"></i>';
							$output.= $button_text;
						if ( $button_icon_right && $button_icon_right !== 'none' ) $output.= '<i class="vcex-button-icon-right fa fa-'. $button_icon_right .'"></i>';
					$output.= '</span>';
				$output.= '</a>';
			$output .='</div>';
		}
		$output .= '</div>';
		
		return $output;
	}
}
add_shortcode( 'vcex_callout', 'vcex_callout_shortcode' );



/**
	Add to Visual Composer
**/
vc_map( array(
	"name"					=> __( "Callout", 'vcex' ),
	"description"			=> __( "Call to action section with or without button.", 'vcex' ),
	"base"					=> "vcex_callout",
	"icon"					=> "icon-wpb-vcex-callout",
	"category"				=> __('Content', 'js_composer'),
	"params"				=> array(
		array(
			"type"				=> "textarea_html",
			"holder"			=> "div",
			"class"				=> "vcex-callout",
			"heading"			=> __( "Callout Content", 'vcex' ),
			"param_name"		=> "content",
			"value"				=> __( "Enter your content here.", 'vcex' ),
		),
		array(
		"type"			=> "dropdown",
		"heading"			=> __("CSS Animation", "vcex"),
		"param_name"		=> "css_animation",
		"value"			=> array(
			__("No", "vcex")					=> '',
			__("Top to bottom", "vcex")			=> "top-to-bottom",
			__("Bottom to top", "vcex")			=> "bottom-to-top",
			__("Left to right", "vcex")			=> "left-to-right",
			__("Right to left", "vcex")			=> "right-to-left",
			__("Appear from center", "vcex")	=> "appear"),
			"description"	=> __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "vcex")
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Button: URL", 'vcex' ),
			"param_name"	=> "button_url",
			"value"			=> "",
			"description"	=> __( "Enter a target URL for your button. Don't forget the http:// at the front.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Button: Text", 'vcex' ),
			"param_name"	=> "button_text",
			"value"			=> "",
			"description"	=> __( "Your button Text.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button Style", 'vcex' ),
			"param_name"	=> "button_style",
			"description"	=> __( "Select a button style.", 'vcex' ),
			"value"			=> array(
				__( "Graphical", "vcex")	=> "graphical",
				__( "Flat", "vcex" )		=> "flat",
				__( "3D", "vcex" )			=> "three-d",
				__( "Outline", "vcex" )		=> "outline",
			),
			"description"	=> __( "Select a style for this button.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button: Color", 'vcex' ),
			"param_name"	=> "button_color",
			"value"			=> array(
				__( "Black", "vcex")	=> "black",
				__( "Blue", "vcex" )	=> "blue",
				__( "Brown", "vcex" )	=> "brown",
				__( "Grey", "vcex" )	=> "grey",
				__( "Green", "vcex" )	=> "green",
				__( "Gold", "vcex" )	=> "gold",
				__( "Orange", "vcex" )	=> "orange",
				__( "Pink", "vcex" )	=> "pink",
				__( "Red", "vcex" )		=> "red",
				__( "Rosy", "vcex" )	=> "rosy",
				__( "Teal", "vcex" )	=> "teal",
			),
			"description"	=> __( "Select a color for this button. Note: Custom colors aren't supported for several reasons.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Button: Border Radius", 'vcex' ),
			"param_name"	=> "button_border_radius",
			"value"			=> "3px",
			"description"	=> __( 'Custom border radius. This gives your button "roundedness".', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button: Link Target", 'vcex' ),
			"param_name"	=> "button_target",
			"value"			=> array(
				__( "Self", "vcex")		=> "self",
				__( "Blank", "vcex" )	=> "blank",
			),
			"description"	=> __( 'Your link target. Choose self to open the link in the same browser tab and blank to open in a new tab.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button: Rel", 'vcex' ),
			"param_name"	=> "button_rel",
			"value"			=> array(
				__( "None", "vcex")			=> "none",
				__( "Nofollow", "vcex" )	=> "nofollow",
			),
			"description"	=> __( 'Select a rel attribute for your link.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button: Icon Left", 'vcex' ),
			"param_name"	=> "button_icon_left",
			"description"	=> sprintf( __( 'Icon to the left of your button text. See all the icons at %s', 'vcex' ), '<a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>' ),
			"value"			=> vcex_font_icons_array(),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button: Icon Right", 'vcex' ),
			"param_name"	=> "button_icon_right",
			"description"	=> sprintf( __( 'Icon to the right of your button text. See all the icons at %s', 'vcex' ), '<a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>' ),
			"value"			=> vcex_font_icons_array(),
		),
	)
) );
?>