<?php
/**
	Register Shortcode
**/
if( !function_exists( 'vcex_news_shortcode' ) ) {

	function vcex_news_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> 'all',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'count'					=> '12',
				'columns'				=> '3',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'header'				=> '',
				'heading'				=> 'h3',
				'date'					=> 'true',
				'excerpt_length'		=> '15',
				'read_more'				=> 'false',
				'read_more_text'		=> __( 'read more', 'vcex' ),
				'filter_content'		=> 'false',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=>'',
				'css_animation'			=> '',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'featured_image'		=> 'false',
			), $atts));

		// Include categories
		$include_categories = ( ! empty( $include_categories ) ) ? $include_categories : $term_slug;
		$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
		if ( $include_categories ) {
			$include_categories = explode( ',', $include_categories );
		}

		// Exclude categories
		if ( $exclude_categories ) {
			$exclude_categories = explode( ',', $exclude_categories );
			if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
			$exclude_categories = array(
					'taxonomy'	=> 'category',
					'field'		=> 'slug',
					'terms'		=> $exclude_categories,
					'operator'	=> 'NOT IN',
				);
			} else {
				$exclude_categories = '';
			}
		}
		
		// Start Tax Query
		if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
			$include_categories = array(
				'taxonomy'	=> 'category',
				'field'		=> 'slug',
				'terms'		=> $include_categories,
				'operator'	=> 'IN',
			);
		} else {
			$include_categories = '';
		}
		
		// The Query
		$vcex_query = new WP_Query(
			array(
				'post_type'			=> 'post',
				'posts_per_page'	=> $count,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'no_found_rows'		=> true,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
					array(
						'taxonomy'	=> 'post_format',
						'field'		=> 'slug',
						'terms'		=> array( 'post-format-quote','post-format-link' ),
						'operator'	=> 'NOT IN',
					),
				),
			)
		);

		$output = '';

		//Output posts
		if( $vcex_query->posts ) :

			ob_start();
		
			$unique_id = $unique_id ? ' id="'. $unique_id .'"' : NULL;
			
			// CSS animations
			$css_animation_classes = '';
			if ( $css_animation !== '' ) {
				$css_animation_classes = 'wpb_animate_when_almost_visible wpb_'. $css_animation .'';
			} ?>
		
			<div class="vcex-recent-news <?php echo $css_animation_classes; ?>" <?php echo $unique_id; ?>>
			
			<?php
			// Header
			if ( $header !== '' ) { ?>
				<h2 class="vcex-recent-news-header theme-heading">
					<span><?php echo $header; ?></span>
				</h2>
			<?php } ?>
		
			<?php
			// Loop through posts
			foreach ( $vcex_query->posts as $post ) : setup_postdata( $post );
			
				// Post VARS
				$post_id = $post->ID;
				$url = get_permalink($post_id);
				$post_title = get_the_title($post_id);
				$post_excerpt = $post->post_excerpt;
				$post_content = $post->post_content;
				$post_format = get_post_format($post_id);
				$post_video = get_post_meta( $post_id, 'wpex_post_oembed', true );

				// Image
				$featured_img_url = wp_get_attachment_url( get_post_thumbnail_id( $post_id ) );
				$img_width = $img_width ? intval($img_width) : '9999';
				$img_height = $img_height ? intval($img_height) : '9999';
				$thumbnail_hard_crop = $img_height == '9999' ? false : true;
				$featured_img_src = aq_resize( $featured_img_url, $img_width, $img_height, $thumbnail_hard_crop ); ?>

				<article id="post-<?php echo $post_id; ?>" class="vcex-recent-news-entry">
					<?php
					// Date
					if ( $date ) { ?>
						<div class="vcex-recent-news-date">
							<span class="day">
								<?php echo get_the_time('d', $post_id); ?>
							</span>
							<span class="month">
								<?php echo get_the_time('M', $post_id); ?>
							</span>
						</div>
					<?php } ?>
					<div class="vcex-news-entry-details vcex-clearfix">
						<?php
						// Thumbnail
						if ( 'true' == $featured_image ) {
							if ( 'video' == $post_format && $post_video ) { ?>
								<div class="vcex-news-entry-video vcex-video-wrap clr">
									<?php echo wp_oembed_get( $post_video ); ?>
								</div>
							<?php } else { ?>
								<div class="vcex-news-entry-thumbnail clr">
									<a href="<?php echo $url; ?>" title="<?php echo $post_title; ?>">
										<img src="<?php echo $featured_img_src; ?>" alt="<?php echo $post_title; ?>" />
									</a>
								</div>
							<?php } ?>
						<?php } ?>
						<header class="vcex-recent-news-entry-title">
							<<?php echo $heading; ?> class="vcex-recent-news-entry-title-heading">
								<a href="<?php echo $url; ?>" title="<?php $post_title; ?>"><?php echo $post_title; ?></a>
							</<?php echo $heading; ?>>
						</header><!-- .vcex-recent-news-entry-title -->
						<div class="vcex-recent-news-entry-excerpt vcex-clearfix">
							<?php
							if ( !empty($post_excerpt) ) {
								echo $post_excerpt .'...';
							} else {
								$read_more = ( $read_more == 'true' ) ? true : false;
								vcex_excerpt( $excerpt_length, $read_more, $read_more_text, $post_id );
							} ?>
						</div><!-- .vcex-recent-news-entry-excerpt -->
					</div><!-- .vcex-recent-news-entry-details -->
				</article><!-- .vcex-recent-news-entry -->

			<?php
			// End foreach loop
			endforeach; ?>
			
			</div><!-- .vcex-recent-news -->
			<div class="vcex-clear-floats"></div>
		
		<?php
		endif; // End has posts check
				
		// Set things back to normal
		wp_reset_postdata();

		// Return data
		return ob_get_clean();
		
	}
}
add_shortcode("vcex_recent_news", "vcex_news_shortcode");


/**
	Add to visual composer
**/
vc_map( array(
	"name"					=> __( "Recent News", 'vcex' ),
	"description"			=> __( "Recent blog posts.", 'vcex' ),
	"base"					=> "vcex_recent_news",
	"class"					=> "",
	"category"				=> __( "Blog", "vcex" ),
	'admin_enqueue_js'		=> "",
	'admin_enqueue_css'		=> "",
	"icon"					=> "icon-wpb-vcex-recent_news",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("CSS Animation", "vcex"),
			"param_name"		=> "css_animation",
			"value"			=> array(
				__("No", "vcex")					=> '',
				__("Top to bottom", "vcex")			=> "top-to-bottom",
				__("Bottom to top", "vcex")			=> "bottom-to-top",
				__("Left to right", "vcex")			=> "left-to-right",
				__("Right to left", "vcex")			=> "right-to-left",
				__("Appear from center", "vcex")	=> "appear"
			),
			"description"	=> __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "vcex"),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Title", 'vcex' ),
			"param_name"	=> "header",
			"value"			=> "",
			"descrtiption"	=> __( "You can display a title above your recent posts.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "all",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Post Count", 'vcex' ),
			"param_name"	=> "count",
			"value"			=> "3",
			"descrtiption"	=> __( "How many posts do you wish to show.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )			=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")			=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Display Featured Media?", 'vcex' ),
			"param_name"	=> "featured_image",
			"value"			=> array(
				__( "False", "vcex" )	=> "false",
				__( "True", "vcex")		=> "true",
			),
			"description"	=> __("Display your featured images and post format videos?","vcex"),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Featured Image Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping width. Enter 9999 for no cropping.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "featured_image",
				'value' => "true"
			),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Featured Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping height. Enter 9999 for no cropping.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "featured_image",
				'value' => "true"
			),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Excerpt Length", 'vcex' ),
			"param_name"	=> "excerpt_length",
			"value"			=> "30",
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Read More Link?", 'vcex' ),
			"param_name"	=> "read_more",
			"value"			=> array(
				__( "False", "vcex" )	=> "false",
				__( "True", "vcex")		=> "true",
			),
			"description"	=> __("Display a read more link after the excerpt?","vcex"),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Read More Text", 'vcex' ),
			"param_name"	=> "read_more_text",
			"value"			=> "",
			"description"	=> __("Enter your custom text for the readmore button.","vcex"),
			"dependency"	=> Array(
				'element'	=> "read_more",
				'value'		=> "true"
			),
		),
	)
) );