<?php
/**
	Add Blog Grid Shortcode
**/
if( !function_exists( 'vcex_blog_grid_shortcode' ) ) {

	function vcex_blog_grid_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> '',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'posts_per_page'		=> '4',
				'grid_style'			=> 'fit_columns',
				'columns'				=> '3',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'filter'				=> 'true',
				'thumbnail_link'		=> 'post',
				'entry_media'			=> "true",
				'img_crop'				=> 'true',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'thumb_link'			=> 'post',
				'img_filter'			=> '',
				'title'					=> 'true',
				'date'					=> 'true',
				'excerpt'				=> 'true',
				'excerpt_length'		=> '15',
				'read_more'				=> 'false',
				'read_more_text'		=> __( 'read more', 'vcex' ),
				'pagination'			=> 'false',
				'filter_content'		=> 'false',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=> '',
				'all_text'				=> __( 'All', 'wpex' ),
			), $atts));
			
		// Get global $post var
		global $post;
			
		// Include categories
		$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
		$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
		$filter_cats_include = '';
		if ( $include_categories ) {
			$include_categories = explode( ',', $include_categories );
			$filter_cats_include = array();
			foreach ( $include_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'category' );
				$filter_cats_include[] = $key->term_id;
			}
		}

		// Exclude categories
		$filter_cats_exclude = '';
		if ( $exclude_categories ) {
			$exclude_categories = explode( ',', $exclude_categories );
			if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
			$filter_cats_exclude = array();
			foreach ( $exclude_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'category' );
				$filter_cats_exclude[] = $key->term_id;
			}
			$exclude_categories = array(
				'taxonomy'	=> 'category',
				'field'		=> 'slug',
				'terms'		=> $exclude_categories,
				'operator'	=> 'NOT IN',
			);
			} else {
				$exclude_categories = '';
			}
		}
		
		// Start Tax Query
		if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
			$include_categories = array(
				'taxonomy'	=> 'category',
				'field'		=> 'slug',
				'terms'		=> $include_categories,
				'operator'	=> 'IN',
			);
		} else {
			$include_categories = '';
		}
		
		// Pagination var
		if( $pagination == 'true' ) {
			global $paged;
			$paged = get_query_var('paged') ? get_query_var('paged') : 1;
		} else {
			$paged = NULL;
		}
		
		// The Query
		$vcex_query = new WP_Query(
			array(
				'post_type'			=> 'post',
				'posts_per_page'	=> $posts_per_page,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'paged'				=> $paged,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		//Output posts
		if( $vcex_query->posts ) :

			$unique_id = $unique_id ? $unique_id : 'blog-'. rand( 1, 100 );
			$img_crop = $img_crop == 'true' ? true : false;
			$read_more = $read_more == 'true' ? true : false;
			
			// Set correct grid class
			$col_class = 'span_8';
			if ( $columns == '1' ) $col_class = 'span_1_of_1';
			if ( $columns == '2' ) $col_class = 'span_1_of_2';
			if ( $columns == '3' ) $col_class = 'span_1_of_3';
			if ( $columns == '4' ) $col_class = 'span_1_of_4';
			if ( $columns == '5' ) $col_class = 'span_1_of_5';
			if ( $columns == '6' ) $col_class = 'span_1_of_6';
			if ( $columns == '7' ) $col_class = 'span_1_of_7';
			if ( $columns == '8' ) $col_class = 'span_1_of_8';
			if ( $columns == '9' ) $col_class = 'span_1_of_9';
			if ( $columns == '10' ) $col_class = 'span_1_of_10';
			if ( $columns == '11' ) $col_class = 'span_1_of_11';
			if ( $columns == '12' ) $col_class = 'span_1_of_12';
			
			// Looad lightbox scripts
			if ( $thumb_link == 'lightbox' ) {
				wp_enqueue_script( 'magnific-popup' );
				wp_enqueue_script( 'vcex-lightbox' );
			}
			
			// Load Masonry scripts
			if ( $filter == 'true' || $grid_style == 'masonry' ) {
				wp_enqueue_script( 'vcex-isotope' ); // Load Isotope Script
			}
			
			ob_start(); ?>
				<?php
				// Display filter links
				if ( $filter == 'true' ) {
					$terms = get_terms( 'category', array(
						'include'	=> $filter_cats_include,
						'exclude'	=> $filter_cats_exclude,
					) );
					$terms = apply_filters( 'vcex_blog_grid_get_terms', $terms );
					if( $terms ) { ?>
						<ul class="vcex-blog-filter filter-<?php echo $unique_id; ?> vcex-filter-links clr">
							<li class="active"><a href="#" data-filter="*"><span><?php echo $all_text; ?></span></a></li>
							<?php foreach ($terms as $term ) : ?>
								<li><a href="#" data-filter=".cat-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></a></li>
							<?php endforeach; ?>
						</ul><!-- .vcex-blog-filter -->
					<?php } ?>
				<?php } ?>
				
				<?php
				if ( $filter == 'true' || $grid_style == 'masonry' ) { ?>
				<script type="text/javascript">
				jQuery(function($){
					$(window).load(function() {
							function wpexBlogIsotope() {
								var $container = $('#<?php echo $unique_id; ?>');
								$container.isotope({
									itemSelector: '.vcex-blog-entry'
								});
							} wpexBlogIsotope();
							var $filterLinks = $('.filter-<?php echo $unique_id; ?> a');
							$filterLinks.each( function() {
								var $filterableDiv = $(this).data('filter');
								if ( $filterableDiv == '*' ) {
									// ignore this one
								} else {
									if ( $($filterableDiv).width() ) {
										// keep these
									} else {
										// remove these
										$(this).parent().hide();
									}
								}
							});
							$filterLinks.css({ opacity: 1 } );
							$filterLinks.click(function(){
							var selector = $(this).attr('data-filter');
								$('#<?php echo $unique_id; ?>').isotope({ filter: selector });
								$(this).parents('ul').find('li').removeClass('active');
								$(this).parent('li').addClass('active');
							return false;
							});
							var isIE8 = $.browser.msie && +$.browser.version === 8;
							if (isIE8) {
								document.body.onresize = function () {
									wpexBlogIsotope();
								};
							} else {
								$(window).resize(function () {
									wpexBlogIsotope();
								});
							}
							window.addEventListener("orientationchange", function() {
								wpexBlogIsotope();
							});
					});
				});
				</script>
				<?php } ?>
		
				<div class="wpex-row vcex-blog-grid vcex-clearfix <?php if ( $filter == 'true' || $grid_style == 'masonry' ) { echo 'vcex-masonry-grid'; } ?>" id="<?php echo $unique_id; ?>">
					<?php
					// Define counter var to clear floats
					$count='';
					// Loop through posts
					foreach ( $vcex_query->posts as $post ) : setup_postdata( $post );
						// Post ID var
						$post_id = $post->ID;
						// Add to counter var
						$count++;
						// Get post format
						$format = get_post_format( $post_id );
						$video_url = get_post_meta( $post_id, 'wpex_post_oembed', true );
						// General Class
						$entry_classes = 'vcex-blog-entry col';
						// Counter class
						$entry_classes .= ' col-'. $count;
						// Column class
						$entry_classes .= ' '. $col_class;
						// Create a list of terms to add as classes to the entry
						$post_terms = get_the_terms( $post, 'category' ); 
						if ( $post_terms ) {
							foreach ( $post_terms as $post_term ) {
								$entry_classes .= ' cat-'. $post_term->term_id;
							}
						}
						if ( "false" == $entry_media ) {
							$entry_classes .= ' vcex-blog-no-media-entry';
						} ?>
						<article id="#post-<?php the_ID(); ?>" class="<?php echo $entry_classes; ?>">
							<?php if ( "true" == $entry_media ) { ?>
								<?php $img_filter_class = $img_filter ? 'vcex-'. $img_filter : ''; ?>
								<?php if ( "video" == $format && $video_url ) { ?>
									<div class="vcex-blog-entry-media">
										<div class="vcex-video-wrap">
											<?php echo wp_oembed_get($video_url); ?>
										</div>
									</div><!-- .vcex-blog-entry-media -->
								<?php } elseif( has_post_thumbnail() ) { ?>
									<div class="vcex-blog-entry-media <?php echo $img_filter_class; ?>">
										<?php if ( $thumb_link == 'post' ||  $thumb_link == 'lightbox' ) { ?>
											<?php if ( $thumb_link == 'post' ) { ?>
												<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
											<?php } ?>
											<?php if ( $thumb_link == 'lightbox' ) { ?>
												<?php if ( $format == 'video' ) { ?>
													<a href="<?php echo $video_url; ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="vcex-lightbox-video">
												<?php } else { ?>
													<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="vcex-lightbox">
												<?php } ?>
											<?php } ?>
										<?php } ?>
											<img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id() ), $img_width,  $img_height, $img_crop ); ?>" alt="<?php the_title(); ?>" class="vcex-blog-entry-img" />
										<?php if ( $thumb_link == 'post' ||  $thumb_link == 'lightbox' ) { ?>
											</a>
										<?php } ?>
									</div><!-- .blog-entry-media -->
								<?php } ?>
							<?php } ?>
							<?php if ( $title == 'true' || $excerpt == 'true' ) { ?>
								<div class="vcex-blog-entry-details clr">
									<?php
									// Post Title
									if ( $title == 'true' ) { ?>
										<h2 class="vcex-blog-entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
									<?php } ?>
									<?php
									// Post Date
									if ( $date == 'true' ) { ?>
										<div class="vcex-blog-entry-date"><?php echo get_the_date(); ?></div>
									<?php } ?>
									<?php
									// Excerpt
									if ('true' ==  $excerpt  || 'true' == $read_more ) {
										if ( 'true' != $excerpt ){
											$excerpt_length = '0';
										} ?>
										<div class="vcex-blog-entry-excerpt clr">
											<?php if ( '9999' == $excerpt_length  ) {
												the_content();
											} else {
												vcex_excerpt( $excerpt_length, $read_more, $read_more_text );
											} ?>
										</div>
									<?php } ?>
								</div><!-- .blog-entry-details -->
							<?php } ?>
						</article><!-- .blog-entry -->
					<?php
					// Reset counter
					if ( $count == $columns ) {
						$count = '0';
					} ?>
					<?php endforeach; ?>
				</div><!-- .vcex-blog-grid -->
				
				<?php
				// Paginate Posts
				if( $pagination == 'true' ) {
					$total = $vcex_query->max_num_pages;
					$big = 999999999; // need an unlikely integer
					if( $total > 1 )  {
						if( !$current_page = get_query_var('paged') )
							$current_page = 1;
						if( get_option('permalink_structure') ) {
							$format = 'page/%#%/';
						} else {
							$format = '&paged=%#%';
						}
						 echo paginate_links(array(
							'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format'		=> $format,
							'current'		=> max( 1, get_query_var('paged') ),
							'total'			=> $total,
							'mid_size'		=> 2,
							'type'			=> 'list',
							'prev_text'		=> '&laquo;',
							'next_text'		=> '&raquo;',
						) );
					}
				}
			
			endif; // End has posts check
					
			// Set things back to normal
			wp_reset_postdata();
		
		return ob_get_clean();
		
	}
	add_shortcode("vcex_blog_grid", "vcex_blog_grid_shortcode");
}




/**
	Add to Visual Composer
**/
vc_map( array(
	"name"					=> __( "Blog Grid", 'vcex' ),
	"description"			=> __( "Recent blog posts grid", 'vcex' ),
	"base"					=> "vcex_blog_grid",
	"class"					=> "vcex_blog_grid",
	"category"				=> __( "Blog", "vcex" ),
	"icon" 					=> "icon-wpb-vcex-blog_grid",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Category Filter", 'vcex' ),
			"param_name"	=> "filter",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Do you wish to display an animated category filter?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( 'Custom Category Filter "All" Text', 'vcex' ),
			"param_name"	=> "all_text",
			"value"			=> "",
			"description"	=> __( 'Custom text for the "all" button in the category filter.', 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "filter",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"description"	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				 __( "DESC", "vcex")	=> "DESC",
				 __( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"description"	=> sprintf( __( 'Select how to sort retrieved posts. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )			=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")			=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Pagination", 'vcex' ),
			"param_name"	=> "pagination",
			"value"			=> array(
				__( "False", "vcex")	=> "false",
				__( "True", "vcex" )	=> "true",
			),
			"description"	=> __("Important: Pagination will not work on your homepage because of how WordPress works","vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Columns", 'vcex' ),
			"param_name"	=> "columns",
			"admin_label"	=> true,
			"value" 		=> array(
				__( 'Four', 'wpex' )	=> '4',
				__( 'Three', 'wpex' )	=> '3',
				__( 'two', 'wpex' )		=> '2',
				__( 'One', 'wpex' )		=> '1',
			),
			"description"	=> __( "How many columns for your grid?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Posts Per Page", 'vcex' ),
			"param_name"	=> "posts_per_page",
			"value"			=> "4",
			"description"	=> __( "How many items do you wish to show?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Grid Style", 'vcex' ),
			"param_name"	=> "grid_style",
			"value"			=> array(
				__( "Fit Columns", "vcex")	=> "fit-columns",
				__( "Masonry", "vcex" )		=> "masonry",
			),
			"description"	=> __( "Important: If the category filter is enabled above the grid will always be masonry style.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Entry Media", 'vcex' ),
			"param_name"	=> "entry_media",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Should featured images and post videos be displayed in the grid?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Image Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping width. Enter 9999 for no cropping.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "entry_media",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Image Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping height. Enter 9999 for no cropping.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "entry_media",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Hard Crop Images?", 'vcex' ),
			"param_name"	=> "img_crop",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Select to hard crop the image or not. If set true your images will be cropped in the middle based on the cropping dimensions set above.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "entry_media",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Filter", 'vcex' ),
			"param_name"	=> "img_filter",
			"value"			=> vcex_image_filters(),
			"description"	=> __( "Select a custom filter style for your images.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "entry_media",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Links To", 'vcex' ),
			"param_name"	=> "thumb_link",
			"value"			=> array(
				__( "Post", "vcex")			=> "post",
				__( "Lightbox", "vcex" )	=> "lightbox",
				__( "Nowhere", "vcex" )		=> "nowhere",
			),
			"description"	=> __( "Default link behaviour on the images.", 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "entry_media",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Title", 'vcex' ),
			"param_name"	=> "title",
			"value"			=> array(
				__( "Yes", "vcex")	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post title?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Date", 'vcex' ),
			"param_name"	=> "date",
			"value"			=> array(
				__( "Yes", "vcex")	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post date?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Excerpt", 'vcex' ),
			"param_name"	=> "excerpt",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Excerpt Length", 'vcex' ),
			"param_name"	=> "excerpt_length",
			"value"			=> "15",
			"dependency"	=> Array(
				'element'	=> "excerpt",
				'value'		=> "true"
			),
			"description"	=> __( 'Enter a custom excerpt length. Will trim the excerpt by this number of words. Enter "9999" to display the_content instead of the auto excerpt.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Read More", 'vcex' ),
			"param_name"	=> "read_more",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )		=> "false",
			),
			"description"	=> __( "Display post readmore button after excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Read More Text", 'vcex' ),
			"param_name"	=> "read_more_text",
			"value"			=> "",
			"description"	=> __("Enter your custom text for the readmore button.","vcex"),
			"dependency"	=> Array(
				'element'	=> "read_more",
				'value'		=> "true"
			),
		),
	)
) );