<?php
/**
	Add testimonials Grid Shortcode
**/
if( !function_exists( 'vcex_testimonials_grid_shortcode' ) ) {

	function vcex_testimonials_grid_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> 'all',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'posts_per_page'		=> '12',
				'grid_style'			=> 'fit_columns',
				'columns'				=> '4',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'filter'				=> 'true',
				'title'					=> 'true',
				'excerpt'				=> 'true',
				'excerpt_length'		=> '15',
				'read_more'				=> 'false',
				'read_more_text'		=> __( 'read more', 'vcex' ),
				'pagination'			=> 'false',
				'filter_content'		=> 'false',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=> '',
				'all_text'				=> __( 'All', 'wpex' ),
			), $atts));
			
		// Get global $post var
		global $post;
			
		// Include categories
		$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
		$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
		$filter_cats_include = '';
		if ( $include_categories ) {
			$include_categories = explode( ',', $include_categories );
			$filter_cats_include = array();
			foreach ( $include_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'testimonials_category' );
				$filter_cats_include[] = $key->term_id;
			}
		}

		// Exclude categories
		$filter_cats_exclude = '';
		if ( $exclude_categories ) {
			$exclude_categories = explode( ',', $exclude_categories );
			if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
			$filter_cats_exclude = array();
			foreach ( $exclude_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'testimonials_category' );
				$filter_cats_exclude[] = $key->term_id;
			}
			$exclude_categories = array(
					'taxonomy'	=> 'testimonials_category',
					'field'		=> 'slug',
					'terms'		=> $exclude_categories,
					'operator'	=> 'NOT IN',
				);
			} else {
				$exclude_categories = '';
			}
		}
		
		// Start Tax Query
		if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
			$include_categories = array(
				'taxonomy'	=> 'testimonials_category',
				'field'		=> 'slug',
				'terms'		=> $include_categories,
				'operator'	=> 'IN',
			);
		} else {
			$include_categories = '';
		}
		
		// Pagination var
		if( $pagination == 'true' ) {
			global $paged;
			$paged = get_query_var('paged') ? get_query_var('paged') : 1;
		} else {
			$paged = NULL;
		}
		
		// The Query
		$vcex_query = new WP_Query(
			array(
				'post_type'			=> 'testimonials',
				'posts_per_page'	=> $posts_per_page,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'paged'				=> $paged,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		//Output posts
		if( $vcex_query->posts ) :
		
			$rand_num = rand(1, 100);
			$unique_id = $unique_id ? $unique_id : 'testimonials-'. rand( 1, 100 );
			
			// Set correct grid class
			$col_class = 'span_8';
			if ( $columns == '1' ) $col_class = 'span_1_of_1';
			if ( $columns == '2' ) $col_class = 'span_1_of_2';
			if ( $columns == '3' ) $col_class = 'span_1_of_3';
			if ( $columns == '4' ) $col_class = 'span_1_of_4';
			if ( $columns == '5' ) $col_class = 'span_1_of_5';
			if ( $columns == '6' ) $col_class = 'span_1_of_6';
			if ( $columns == '7' ) $col_class = 'span_1_of_7';
			if ( $columns == '8' ) $col_class = 'span_1_of_8';
			if ( $columns == '9' ) $col_class = 'span_1_of_9';
			if ( $columns == '10' ) $col_class = 'span_1_of_10';
			if ( $columns == '11' ) $col_class = 'span_1_of_11';
			if ( $columns == '12' ) $col_class = 'span_1_of_12';
			
			// Load Masonry scripts
			if ( $filter == 'true' || $grid_style == 'masonry' || $grid_style == 'no_margins' ) {
				wp_enqueue_script( 'vcex_isotope' ); // Load Isotope Script
			}
			
			ob_start(); ?>
				<?php
				// Display filter links
				if ( $filter == 'true' && taxonomy_exists( 'testimonials_category' ) ) {
					$terms = get_terms( 'testimonials_category', array(
						'include'	=> $filter_cats_include,
						'exclude'	=> $filter_cats_exclude,
					) );
					$terms = apply_filters( 'vcex_testimonials_grid_get_terms', $terms );
					if( $terms ) { ?>
						<ul class="vcex-testimonials-filter filter-<?php echo $unique_id; ?> vcex-filter-links clr">
							<li class="active"><a href="#" data-filter="*"><span><?php echo $all_text; ?></span></a></li>
							<?php foreach ($terms as $term ) : ?>
								<li><a href="#" data-filter=".cat-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></a></li>
							<?php endforeach; ?>
						</ul><!-- .vcex-testimonials-filter -->
					<?php }
				} ?>
				
				<?php
				if ( $filter == 'true' || $grid_style == 'masonry' || $grid_style == 'no_margins' ) { ?>
				<script type="text/javascript">
				jQuery(function($){
					$(window).load(function() {
							function wpextestimonialsIsotope() {
								var $container = $('#<?php echo $unique_id; ?>');
								$container.isotope({
									itemSelector: '.testimonial-entry'
								});
							} wpextestimonialsIsotope();
							var $filterLinks = $('.filter-<?php echo $unique_id; ?> a');
							$filterLinks.each( function() {
								var $filterableDiv = $(this).data('filter');
								if ( $filterableDiv == '*' ) {
									// ignore this one
								} else {
									if ( $($filterableDiv).width() ) {
										// keep these
									} else {
										// remove these
										$(this).parent().hide();
									}
								}
							});
							$filterLinks.css({ opacity: 1 } );
							$filterLinks.click(function(){
							  var selector = $(this).attr('data-filter');
								$('#<?php echo $unique_id; ?>').isotope({ filter: selector });
								$(this).parents('ul').find('li').removeClass('active');
								$(this).parent('li').addClass('active');
							  return false;
							});
							var isIE8 = $.browser.msie && +$.browser.version === 8;
							if (isIE8) {
								document.body.onresize = function () {
									wpextestimonialsIsotope();
								};
							} else {
								$(window).resize(function () {
									wpextestimonialsIsotope();
								});
							}
							window.addEventListener("orientationchange", function() {
								wpextestimonialsIsotope();
							});
					});
				});
				</script>
				<?php } ?>
		
				<div class="wpex-row vcex-testimonials-grid vcex-clearfix <?php if ( $filter == 'true' || $grid_style == 'masonry' ) { echo 'vcex-masonry-grid'; } ?>" id="<?php echo $unique_id; ?>">
					<?php
					$count='';
					foreach ( $vcex_query->posts as $post ) : setup_postdata( $post );
					$count++;
					$wpex_testimonial_author = get_post_meta( get_the_ID(), 'wpex_testimonial_author', true );
					$wpex_testimonial_company = get_post_meta( get_the_ID(), 'wpex_testimonial_company', true );
					$wpex_testimonial_url = get_post_meta( get_the_ID(), 'wpex_testimonial_url', true );
					$post_thumb_id = get_post_thumbnail_id();
					$attachment_url = wp_get_attachment_url( $post_thumb_id );
					$width = apply_filters( 'vcex_testimonial_thumb_width', 100 );
					$height = apply_filters( 'vcex_testimonial_thumb_height', 100 );
					$crop = true;
					if ( function_exists('aq_resize') ) {
						$img_url = aq_resize( $attachment_url, $width, $height, $crop );
					} else {
						$img_url = $attachment_url;
					}
					// Add classes to the entries
					$entry_classes = 'testimonial-entry col';
					$entry_classes .= ' '. $col_class;
					$entry_classes .= ' col-'. $count;
					if ( taxonomy_exists( 'testimonials_category' ) ) {
						$post_terms = get_the_terms( $post, 'testimonials_category' );
						if ( $post_terms ) {
							foreach ( $post_terms as $post_term ) {
								$entry_classes .= ' cat-'. $post_term->term_id;
							}
						}
					} ?>
					<article id="#post-<?php the_ID(); ?>" class="<?php echo $entry_classes; ?>">
						<div class="testimonial-entry-content clr">
							<span class="testimonial-caret"></span>
							<?php the_content(); ?>
						</div><!-- .home-testimonial-entry-content-->
						<div class="testimonial-entry-bottom">
							<?php if( has_post_thumbnail() ) { ?>
							<div class="testimonial-entry-thumb">
								<img src="<?php echo $img_url; ?>" alt="<?php echo the_title(); ?>" />
							</div><!-- /testimonial-thumb -->
							<?php } ?>
							<div class="testimonial-entry-meta">
								<?php if ( $wpex_testimonial_author ) { ?>
									<span class="testimonial-entry-author"><?php echo $wpex_testimonial_author; ?></span>
								<?php } ?>
								<?php if ( $wpex_testimonial_company ) { ?>
									<?php if ( $wpex_testimonial_url ) { ?>
										<a href="<?php echo $wpex_testimonial_url; ?>" class="testimonial-entry-company" title="<?php echo $wpex_testimonial_company; ?>" target="_blank"><?php echo $wpex_testimonial_company; ?></a>
									<?php } else { ?>
										<span class="testimonial-entry-company"><?php echo $wpex_testimonial_company; ?></span>
									<?php } ?>
								<?php } ?>
							</div><!-- .testimonial-entry-meta -->
						</div><!-- .home-testimonial-entry-bottom -->
					</article><!-- .testimonials-entry -->
					<?php
					// Reset counter
					if ( $count == $columns ) {
						$count = '';			
					} ?>
					<?php endforeach; ?>
				</div><!-- .vcex-testimonials-grid -->
				
				<?php
				// Paginate Posts
				if( $pagination == 'true' ) {
					$total = $vcex_query->max_num_pages;
					$big = 999999999; // need an unlikely integer
					if( $total > 1 )  {
						 if( !$current_page = get_query_var('paged') )
							 $current_page = 1;
						 if( get_option('permalink_structure') ) {
							 $format = 'page/%#%/';
						 } else {
							 $format = '&paged=%#%';
						 }
						 echo paginate_links(array(
							'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format'		=> $format,
							'current'		=> max( 1, get_query_var('paged') ),
							'total'			=> $total,
							'mid_size'		=> 2,
							'type'			=> 'list',
							'prev_text'	=> '<i class="fa fa-angle-left"></i>',
							'next_text'	=> '<i class="fa fa-angle-right"></i>',
						 ));
					}
				}
			
			endif; // End has posts check
					
			// Set things back to normal
			wp_reset_postdata();
		
		return ob_get_clean();
		
	}
	add_shortcode("vcex_testimonials_grid", "vcex_testimonials_grid_shortcode");
}




/**
	Add to Visual Composer
**/
vc_map( array(
	"name"					=> __( "Testimonials Grid", 'vcex' ),
	"description"			=> __( "Recent testimonials post grid", 'vcex' ),
	"base"					=> "vcex_testimonials_grid",
	"class"					=> "vcex_testimonials_grid",
	"category"				=> __( "Testimonials", "vcex" ),
	"icon" 					=> "icon-wpb-vcex-testimonials_grid",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"description"	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"description"	=> sprintf( __( 'Select how to sort retrieved posts. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )			=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")			=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Columns", 'vcex' ),
			"param_name"	=> "columns",
			"value" 		=> array(
				__('Four','vcex')	=>'4',
				__('Three','vcex')	=>'3',
				__('Two','vcex')	=>'2',
				__('One','vcex')	=>'1',
			),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Posts Per Page", 'vcex' ),
			"param_name"	=> "posts_per_page",
			"value"			=> "-1",
			"description"	=> __( "How many items do you wish to show?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Pagination", 'vcex' ),
			"param_name"	=> "pagination",
			"value"			=> array(
				__( "No", "vcex")	=> "false",
				__( "Yes", "vcex" )	=> "true",
			),
			"description"	=> __("Paginate posts? Important: Pagination will not work on your homepage because of how WordPress works","vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Category Filter", 'vcex' ),
			"param_name"	=> "filter",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Do you wish to display an animated category filter?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( 'Custom Category Filter "All" Text', 'vcex' ),
			"param_name"	=> "all_text",
			"value"			=> "",
			"description"	=> __( 'Custom text for the "all" button in the category filter.', 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "filter",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Grid Style", 'vcex' ),
			"param_name"	=> "grid_style",
			"value"			=> array(
				__( "Fit Columns", "vcex")	=> "fit-columns",
				__( "Masonry", "vcex" )		=> "masonry",
			),
			"description"	=> __( "Important: If the category filter is enabled above the grid will always be masonry style.", 'vcex' ),
		),
	)
) );
?>