<?php
$validated = get_option('revslider-valid', 'false');
$username = get_option('revslider-username', '');
$api_key = get_option('revslider-api-key', '');
$code = get_option('revslider-code', '');
$latest_version = get_option('revslider-latest-version', GlobalsRevSlider::SLIDER_REVISION);
   if(version_compare($latest_version, GlobalsRevSlider::SLIDER_REVISION, '>')){
    //neue version existiert
   }else{
    //up to date
   }

?>

<!-- 
  CONTENT BEFORE ACTIVATION, BASED OF VALIDATION 
-->
<?php if($validated === 'true') {
	?> 
	<div class="revgreen" style="left:0px;top:0px;position:absolute;height:100%;padding:30px 10px;"><i style="color:#fff;font-size:25px" class="eg-icon-check"></i></div>
	<?php 	
} else {
	?> 
	<div class="revred"   style="left:0px;top:0px;position:absolute;height:100%;padding:30px 10px;"><i style="color:#fff;font-size:25px" class="revicon-cancel"></i></div>
	<?php 
}
?>

<div id="rs-validation-wrapper">
	
	<div class="validation-label"><?php _e('Username:',REVSLIDER_TEXTDOMAIN); ?></div> 
	<div class="validation-input"> 
		<input type="text" name="rs-validation-username" <?php echo ($validated === 'true') ? ' readonly="readonly"' : ''; ?> value="<?php echo $username; ?>" />
		<p class="validation-description"><?php _e('Your Envato username.',REVSLIDER_TEXTDOMAIN); ?></p>
	</div>
	<div class="clear"></div>
	
	
	<div class="validation-label"><?php _e('Envato API Key:',REVSLIDER_TEXTDOMAIN); ?> </div> 
	<div class="validation-input">
		<input type="text" name="rs-validation-api-key" value="<?php echo $api_key; ?>" <?php echo ($validated === 'true') ? ' readonly="readonly"' : ''; ?> style="width: 350px;" />
		<p class="validation-description"><?php _e('You can find API key by visiting your Envato Account page, then clicking the My Settings tab. At the bottom of he page you will find your accounts API key.',REVSLIDER_TEXTDOMAIN); ?></p>
	</div>
	<div class="clear"></div>
	
	<div class="validation-label"><?php _e('Purchase code:',REVSLIDER_TEXTDOMAIN); ?></div> 
	<div class="validation-input">
		<input type="text" name="rs-validation-token" value="<?php echo $code; ?>" <?php echo ($validated === 'true') ? ' readonly="readonly"' : ''; ?> placeholder="45afeb91-0e4c-a1d9-2a4a-04ce3b5a3b30" style="width: 350px;" />
		<p class="validation-description"><?php _e('Please enter your CodeCanyon Slider Revolution license key. You can find your key by following the instructions on',REVSLIDER_TEXTDOMAIN); ?><a target="_blank" href="http://www.themepunch.com/home/plugins/wordpress-plugins/revolution-slider-wordpress/where-to-find-the-purchase-code/"><?php _e(' this page.',REVSLIDER_TEXTDOMAIN); ?></a></p>
	</div>
	<div style="height:15px" class="clear"></div>
	
	<span style="display:none" id="rs_purchase_validation" class="loader_round"><?php _e('Please Wait...'); ?></span>

	<a href="javascript:void(0);" <?php echo ($validated !== 'true') ? '' : 'style="display: none;"'; ?> id="rs-validation-activate" class="button-primary revgreen"><?php _e('Activate',REVSLIDER_TEXTDOMAIN); ?></a>
	
	<a href="javascript:void(0);" <?php echo ($validated === 'true') ? '' : 'style="display: none;"'; ?> id="rs-validation-deactivate" class="button-primary revred"><?php _e('Deactivate',REVSLIDER_TEXTDOMAIN); ?></a>
	

	<?php
	if($validated === 'true'){
		?>
		<a href="update-core.php" id="rs-check-updates" class="button-primary revpurple"><?php _e('Search for Updates',REVSLIDER_TEXTDOMAIN); ?></a>
		<?php
	}
	?>
	
</div>

<!-- 
  CONTENT AFTER ACTIVATION, BASED OF VALIDATION 
-->
<?php if($validated === 'true') {
	?> 
	<h3> <?php _e("How to get Support ?",REVSLIDER_TEXTDOMAIN)?>:</h3>				
	<p>
	<?php _e("Please feel free to contact us via our ",REVSLIDER_TEXTDOMAIN)?><a href='http://themepunch.ticksy.com'><?php _e("Support Forum ",REVSLIDER_TEXTDOMAIN)?></a><?php _e("and/or via the ",REVSLIDER_TEXTDOMAIN)?><a href='http://codecanyon.net/item/slider-revolution-responsive-wordpress-plugin/2751380/comments'><?php _e("Item Disscussion Forum",REVSLIDER_TEXTDOMAIN)?></a><br />
	</p> 	
	<?php 	
} else {
	?> 
	<p>
	<?php _e("Please Activate the Slider for ",REVSLIDER_TEXTDOMAIN); ?><strong><?php _e("Premium Support and Auto Updates",REVSLIDER_TEXTDOMAIN); ?></strong><br />
	<?php _e("Not activated Plugin Users should contact the Theme Author for Updates and for Support.",REVSLIDER_TEXTDOMAIN); ?><br />
	</p> 
	<?php 
}
?>
<p><?php _e("Current Version",REVSLIDER_TEXTDOMAIN)?>: <span  class="slidercurrentversion"><?php echo GlobalsRevSlider::SLIDER_REVISION; ?></span><br>
	<?php _e("Available Version",REVSLIDER_TEXTDOMAIN)?>: <span class="slideravailableversion"><?php echo $latest_version; ?></span></p>
