<?php
/**
 * Total functions and definitions.
 *
 * Sets up the theme and provides some helper functions
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 *
 * For more information on hooks, actions, and filters,
 * see http://codex.wordpress.org/Plugin_API
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
 */


/*------------------------------------------------*/
/*	- Define Constants
/*------------------------------------------------*/
define( 'WPEX_JS_DIR_URI', get_template_directory_uri() .'/js/' );
define( 'WPEX_CSS_DIR_UIR', get_template_directory_uri() .'/css/' );
define( 'WPEX_SKIN_DIR', get_template_directory() .'/skins' );
define( 'WPEX_SKIN_DIR_URI', get_template_directory_uri() .'/skins' );
define( 'WPEX_FUNCTIONS_DIR', get_template_directory() .'/functions' );



/*------------------------------------------------*/
/*	- Globals + Theme Setup + Main Skin
/*------------------------------------------------*/

// Define the default $content_width variable
if ( ! isset( $content_width ) ) $content_width = 980;

// Theme setup - load_theme_domain, add_theme_support, register_nav_menus
require_once( WPEX_FUNCTIONS_DIR .'/theme-setup.php' );

// Recommend some useful plugins for this theme via TGMA script
require_once( WPEX_FUNCTIONS_DIR .'/recommend-plugins.php' );

// Localization support
load_theme_textdomain( 'wpex', get_template_directory() .'/languages' );

// Array of Theme Skins
if ( !function_exists( 'wpex_skins' ) ) {
	function wpex_skins() {
		return array(
			'base'				=> __( 'Base', 'wpex' ),
			'minimal-graphical'	=> __( 'Minimal Graphical', 'wpex' ),
			'agent'				=> __( 'Agent', 'wpex' ),
			'neat'				=> __( 'Neat', 'wpex' ),
			'flat'				=> __( 'Flat', 'wpex' ),
			'gaps'				=> __( 'Gaps', 'wpex' ),
		);
	}
}


/*------------------------------------------------*/
/*	- ReduxFramework Admin Panel
/*------------------------------------------------*/

// Remove horrible Redux popup&tracking class
require_once( get_template_directory() . '/functions/redux/tracking-class-override.php' );

// Include the Redux theme options Framework
if ( !class_exists( 'ReduxFramework' ) ) {
	require_once( get_template_directory() . '/admin/framework.php' );
}

// Refine metaboxes - saved for another day
//require_once( get_template_directory() . '/functions/meta/metaboxes/config.php' );

// Tweak the Redux framework
// Register all the theme options
// Registers the wpex_option function
require_once( get_template_directory() . '/functions/admin-config.php' );

// Returns theme options data
require_once( get_template_directory() . '/functions/wpex-option.php' );

// Define branding constant based on theme options
if ( !function_exists( 'wpex_theme_branding') ) {
	function wpex_theme_branding() {
		return wpex_option( 'theme_branding', 'Total' );
	}
}
define( 'WPEX_THEME_BRANDING', wpex_theme_branding() );

// Active Skin
if ( !function_exists( 'wpex_active_skin') ) {
	function wpex_active_skin() {
		$skin = 'base';
		$skin = wpex_option( 'site_theme', 'base' );
		return $skin;
	}
}
define( 'WPEX_ACTIVE_SKIN', wpex_active_skin() );


/*------------------------------------------------*/
/*	- Return active custom post types
/*------------------------------------------------*/
function wpex_active_post_types() {
	$array = array();
	if ( wpex_option( 'portfolio_enable', '1' ) ) {
		$array[] = 'portfolio';
	}
	if ( wpex_option( 'staff_enable', '1' ) ) {
		$array[] = 'staff';
	}
	if ( wpex_option( 'testimonials_enable', '1' ) ) {
		$array[] = 'testimonials';
	}
	return $array;
}
// Set global active post types var
$wpex_active_post_types = wpex_active_post_types();



/*------------------------------------------------*/
/*	- Hooks - VERY IMPORTANT - DONT DELETE EVER!!
/*------------------------------------------------*/
if ( ! is_admin() ) {
	require_once( WPEX_FUNCTIONS_DIR .'/hooks/hooks.php' );
	require_once( WPEX_FUNCTIONS_DIR .'/hooks/hooks-defaults.php' );
}



/*------------------------------------------------*/
/*	- CSS / JS
/*------------------------------------------------*/

// Loads all the core css and js for this theme
require_once( WPEX_FUNCTIONS_DIR .'/scripts.php' );



/*------------------------------------------------*/
/*	- Site Styling, Layout, Custom Fonts
/*------------------------------------------------*/

// Output custom classes to the body tag
require_once( WPEX_FUNCTIONS_DIR .'/body-classes.php' );

// Outputs css for theme panel styling options
require_once( WPEX_FUNCTIONS_DIR .'/styling.php' );

// Outputs css for theme panel layout options
require_once( WPEX_FUNCTIONS_DIR .'/custom-layout.php' );

// Outputs custom css from theme options
require_once( WPEX_FUNCTIONS_DIR .'/custom-css.php' );

// Outputs typography css - fonts
require_once( WPEX_FUNCTIONS_DIR .'/typography.php' );

// Used to add CSS to the <head> tag for your custom background settings
require_once( WPEX_FUNCTIONS_DIR .'/site-background.php' );

// Custom backgrounds on a per-post basis
require_once( WPEX_FUNCTIONS_DIR .'/page-backgrounds.php' );

// Outputs all Theme custom CSS in WP_Head
require_once( WPEX_FUNCTIONS_DIR .'/output-css.php' );



/*------------------------------------------------*/
/*	- Theme Customizer Support
/*------------------------------------------------*/
require_once( WPEX_FUNCTIONS_DIR .'/theme-customizer/customizer.php' );



/*------------------------------------------------*/
/*	- Other Theme Functions
/*------------------------------------------------*/

// Non Admin Function
if ( is_admin() ) {

	// Faster Menu Dashboard
	require_once( WPEX_FUNCTIONS_DIR .'/faster-menu-dashboard.php' );
	
	// TinyMCE buttons & edits
	require_once( WPEX_FUNCTIONS_DIR .'/tinymce/mce-buttons.php' );
		
	// Gallery metabox function used to define images for your gallery post format
	require_once( WPEX_FUNCTIONS_DIR .'/meta/gallery-metabox/gmb-admin.php' );
	
	// Function used to display featured images in your dashboard columns
	if ( '1' == wpex_option( 'blog_dash_thumbs', '1' ) ) {
		require_once( WPEX_FUNCTIONS_DIR .'/dashboard-thumbnails.php' );
	}
	
	// Layerslider mods
	require_once( WPEX_FUNCTIONS_DIR .'/layerslider/layerslider-mods.php' );
		

// Non Admin functions
} else {

	// Returns the correct grid class based on column numbers
	require_once( WPEX_FUNCTIONS_DIR .'/grid.php' );
	
	// Retuns the correct post layout class
	require_once( WPEX_FUNCTIONS_DIR .'/post-layout.php' );
	
	// Adds additional classes to your posts
	require_once( WPEX_FUNCTIONS_DIR .'/post-classes.php' );

	// Header meta view port html
	require_once( WPEX_FUNCTIONS_DIR .'/header/meta-viewport.php' );
	
	// Show/hide the main header depending on current post meta
	require_once( WPEX_FUNCTIONS_DIR .'/header/header-display.php' );

	// Displays the site toggle bar
	require_once( WPEX_FUNCTIONS_DIR .'/header/toggle-bar.php' );
	
	// Displays the site top-bar
	require_once( WPEX_FUNCTIONS_DIR .'/header/top-bar.php' );
	
	// Adds custom classes to the header container
	require_once( WPEX_FUNCTIONS_DIR .'/header/header-classes.php' );
	
	// Outputs the header logo
	require_once( WPEX_FUNCTIONS_DIR .'/header/header-logo.php' );
	
	// Outputs the header menu
	require_once( WPEX_FUNCTIONS_DIR .'/header/header-menu.php' );
	
	// Outputs the header logo
	require_once( WPEX_FUNCTIONS_DIR .'/header/header-aside.php' );
	
	// Outputs js for your retina logo
	require_once( WPEX_FUNCTIONS_DIR .'/header/retina-logo.php' );
	
	// Custom menu walker used to add classes & icons to menus
	require_once( WPEX_FUNCTIONS_DIR .'/header/menu-walker.php');
	
	// Outputs HTML and loads scripts for the responsive toggle menu
	require_once( WPEX_FUNCTIONS_DIR .'/header/mobile-menu.php' );
	
	// Adds a search icon at the end of the menu
	require_once( WPEX_FUNCTIONS_DIR .'/header/menu-search-icon.php' );
	
	// Get the correct header search toggle style
	$wpex_search_style = wpex_option('main_search_toggle_style','overlay');
	if ( $wpex_search_style == 'overlay' ) {
		require_once( WPEX_FUNCTIONS_DIR .'/search/search-overlay.php');
	}
	if ( $wpex_search_style == 'drop_down' ) {
		require_once( WPEX_FUNCTIONS_DIR .'/search/search-dropdown.php');
	}
	if ( $wpex_search_style == 'header_replace' ) {
		require_once( WPEX_FUNCTIONS_DIR .'/search/search-header-replace.php');
	}
	
	// Adds custom classes to blog wraps based on blog styles
	require_once( WPEX_FUNCTIONS_DIR .'/blog/blog-classes.php' );
	
	// Exclude blog categories from the main blog page / index
	require_once( WPEX_FUNCTIONS_DIR .'/blog/blog-exclude-categories.php' );
	
	// Displays related blog posts
	require_once( WPEX_FUNCTIONS_DIR .'/blog/blog-related.php' );

	// Some cool function functions to tweak widgets
	require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-tweaks.php' );
	
	// Returns the correct sidebar region depending on the post/page/archive and theme settings
	require_once( WPEX_FUNCTIONS_DIR .'/widgets/get-sidebar.php' );
	
	// Returns the correct cropped or non-cropped featured image URLs - Requires that the AquaResizer is called first
	require_once( WPEX_FUNCTIONS_DIR .'/featured-images.php');
	
	// Outputs code in the <head> tag for your favicons
	require_once( WPEX_FUNCTIONS_DIR .'/favicon-apple-icons.php' );
	
	// Outputs css for theme panel responsive width options
	require_once( WPEX_FUNCTIONS_DIR .'/responsive-widths.php' );
	
	// Outputs your tracking code in the <head> tag
	require_once( WPEX_FUNCTIONS_DIR .'/tracking-code.php' );
	
	// Used to tweak the_excerpt() function and also defines the wpex_excerpt() function
	require_once( WPEX_FUNCTIONS_DIR .'/excerpts.php' );
	
	// Creates an array of font awesome icons for use in your theme
	require_once( WPEX_FUNCTIONS_DIR .'/font-awesome.php');
	
	// Built-in breadcrumbs function
	require_once( WPEX_FUNCTIONS_DIR .'/breadcrumbs.php' );
	
	// The main page title class - displays title/breadcrumbs/title backgrounds/subheading - etc.
	require_once( WPEX_FUNCTIONS_DIR .'/page-header.php' );
	
	// Pagination functions - default, infinite scroll and next/prev
	require_once( WPEX_FUNCTIONS_DIR .'/pagination.php' );
	
	// Next & Previous single post pagination
	require_once( WPEX_FUNCTIONS_DIR .'/next-prev.php' );
	
	// Outputs the post meta for blog posts & entries
	require_once( WPEX_FUNCTIONS_DIR .'/post-meta.php' );
	
	// Outputs the current post entry avatar
	require_once( WPEX_FUNCTIONS_DIR .'/post-entry-author-avatar.php' );
	
	// Used for the readmore links on standard posts
	require_once( WPEX_FUNCTIONS_DIR .'/post-readmore-link.php' );
	
	// Function used to alter the number of posts displayed for your custom post type archives
	require_once( WPEX_FUNCTIONS_DIR .'/posts-per-page.php' );
	
	// Comments callback function
	require_once( WPEX_FUNCTIONS_DIR .'/comments-callback.php');
	
	// Increase the quality of resized jpgs
	require_once( WPEX_FUNCTIONS_DIR .'/better-jpgs.php' );
	
	// Image cropping/resizing script
	require_once( WPEX_FUNCTIONS_DIR .'/aqua-resizer.php' );
	
	// Used to fix spacing issues with shortcodes + Adds some useful shortcodes
	require_once( WPEX_FUNCTIONS_DIR .'/shortcodes.php' );
	
	// Used to display images defined by the gallery metabox function
	require_once( WPEX_FUNCTIONS_DIR .'/meta/gallery-metabox/gmb-display.php' );
	
	// Output social options as defined in the theme panel
	require_once( WPEX_FUNCTIONS_DIR .'/social-output.php' );
	
	// Used to display your post slider as defined in the wpex_post_slider meta value
	require_once( WPEX_FUNCTIONS_DIR .'/post-slider.php' );
	
	// Outputs the social sharing icons for posts and pages
	require_once( WPEX_FUNCTIONS_DIR .'/social-share.php' );
	
	// Alter the default output of the WordPress gallery shortcode
	if ( wpex_option( 'custom_wp_gallery', '1' ) == '1' ) {
		require_once( WPEX_FUNCTIONS_DIR .'/wp-gallery.php');
	}

	// Responsive videos support
	require_once( WPEX_FUNCTIONS_DIR .'/responsive-videos.php' );
	
} // End else - is_admin()

// Define the widget areas for this theme
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-areas.php' );

// Custom widgets
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-simple-menu.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-social-fontawesome.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-social.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-flickr.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-video.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-posts-thumbnails.php' );
require_once( WPEX_FUNCTIONS_DIR .'/widgets/widget-recent-posts-thumb-grid.php' );

// Footer functions
if ( !is_admin() ) {
	
	// Show/hide the main footer depending on current post meta
	require_once( WPEX_FUNCTIONS_DIR .'/footer/footer-display.php' );
	
	// Show/hide the footer callout depending on current post meta
	require_once( WPEX_FUNCTIONS_DIR .'/footer/footer-callout.php' );
	
	// The footer widgets
	require_once( WPEX_FUNCTIONS_DIR .'/footer/footer-widgets.php' );
	
	// Displays the copyright info in the footer
	require_once( WPEX_FUNCTIONS_DIR .'/footer/footer-bottom.php' );
	
	// Scroll to top link function
	require_once( WPEX_FUNCTIONS_DIR .'/footer/scroll-top-link.php');
	
}

// Function used for defining meta options
require_once( WPEX_FUNCTIONS_DIR .'/meta/usage.php');

// Meta fields for Standard Categories
require_once( WPEX_FUNCTIONS_DIR .'/meta/taxonomies/category-meta.php');

// Loads some js in the backend for showing/hiding meta settings
require_once( WPEX_FUNCTIONS_DIR .'/meta/display.php');

// A few small optimizations for speed - clean up the <head>, remove useless jetpack scripts, etc.
require_once( WPEX_FUNCTIONS_DIR .'/optimizations.php');



/*------------------------------------------------*/
/*	- Portfolio Post Type
/*------------------------------------------------*/

if ( in_array( 'portfolio', $wpex_active_post_types ) ) {
	
	// Register the portfolio post type
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/register-portfolio.php' );

	// Displays portfolio media on single posts
	require_once( WPEX_FUNCTIONS_DIR .'/portfolio/portfolio-single-media.php' );

	// Portfolio Post Featured Video
	require_once( WPEX_FUNCTIONS_DIR .'/portfolio/portfolio-featured-video.php' );
	
	// Displays an array of portfolio categories
	require_once( WPEX_FUNCTIONS_DIR .'/portfolio/portfolio-categories.php' );
	
	// Displays related portfolio items
	require_once( WPEX_FUNCTIONS_DIR .'/portfolio/portfolio-related.php' );

}



/*------------------------------------------------*/
/*	- Post Series custom Taxonomy
/*------------------------------------------------*/

if ( wpex_option( 'post_series', '1' ) ) {
	
	// Registers the post series custom taxonomy for the standard post type
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/register-post-series.php' );
	
}

require_once( WPEX_FUNCTIONS_DIR .'/blog/post-series.php' );



/*------------------------------------------------*/
/*	- Staff Post Type
/*------------------------------------------------*/

if ( in_array( 'staff', $wpex_active_post_types ) ) {
	
	// Register the staff custom post type
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/register-staff.php' );
	
}

if ( ! is_admin() ) {
	
	// Used to display the social options for your staff members
	require_once( WPEX_FUNCTIONS_DIR .'/staff/staff-social.php' );
	
	// Staff entry image overlay
	require_once( WPEX_FUNCTIONS_DIR .'/staff/staff-overlay.php' );
	
	// Related staff posts
	require_once( WPEX_FUNCTIONS_DIR .'/staff/staff-related.php' );

}



/*------------------------------------------------*/
/*	- Testimonials Post Type
/*------------------------------------------------*/

if ( in_array( 'testimonials', $wpex_active_post_types ) ) {
	
	// Register the testimonials custom post type
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/register-testimonials.php' );
	
}



/*------------------------------------------------*/
/*	- Custom Post Type & Taxonomy Functions
/*------------------------------------------------*/

if ( ! empty( $wpex_active_post_types ) ) {

	// Function used to alter your post type labels via theme options
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/post-type-labels.php' );

	// Function used to alter your taxonomy labels via theme options
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/taxonomies-labels.php' );

	// Tweak custom post types based on theme options
	require_once( WPEX_FUNCTIONS_DIR .'/posttypes-taxonomies/tweak.php' );

}



/*------------------------------------------------*/
/*	- WooCommerce
/*------------------------------------------------*/

// WooCommerce specific functions
if ( class_exists( 'Woocommerce' ) ) {
	
	if ( ! is_admin() ) {
	
		// Adds classes for the WooCommerce main layouts - sidebar, no sidebar, etc.
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-layouts.php' );
		
		// Remove Woo scripts
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-scripts.php' );
		
		// Alter WooCommerce columns/pagination
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-columns.php' );
		
		// Change default Woo Image sizes
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-images.php' );
		
		// Product entry media - featured image / slider / image swap
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-product-entry-media.php' );
		
		// Overrides the default WooCommerce category image output
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-category-image.php' );

		// Other Woo Tweaks
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-other-tweaks.php' );
	
	} // End if is admin

	// Display shopping cart $ in the nav
	if ( wpex_option( 'woo_menu_icon', '1' ) ) {
		require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-menucart.php' );
	}
	
}

// Cart widget displays current cart items
if ( ! is_admin() ) {
	require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-cartwidget-overlay.php' );
	require_once( WPEX_FUNCTIONS_DIR .'/woocommerce/woo-cartwidget-dropdown.php' );
}



/*------------------------------------------------*/
/*	- Visual Composer Tweaks
/*------------------------------------------------*/

// Set composer settings pages as settings page.
if( function_exists( 'vc_set_as_theme' ) ) {
	
	// Set Visual Composer to run in Theme Mode
	vc_set_as_theme(true);

	// Run the Visual Composer Extension
	if ( function_exists( 'visual_composer_extension_run' ) ) {
		visual_composer_extension_run();
	}

	// Disable front-end composer - Too buggy at the momment
	if ( wpex_option( 'disable_composer_frontend', '1' ) && function_exists( 'vc_disable_frontend' ) ) {
		vc_disable_frontend();
	}
	
	// Remove certain default VC modules
	require_once( WPEX_FUNCTIONS_DIR .'/visual-composer/remove.php' );
	
	// Add new parameters to VC items
	require_once( WPEX_FUNCTIONS_DIR .'/visual-composer/add-params.php' );
	
	// Visual Composer Filter tweaks
	require_once( WPEX_FUNCTIONS_DIR .'/visual-composer/filters.php' );

	// Tweaks for the front-end composer
	require_once( WPEX_FUNCTIONS_DIR .'/visual-composer/frontend.php' );

}



/*------------------------------------------------*/
/*	- Load Skin Class Last
/*------------------------------------------------*/
if ( 'base' != wpex_active_skin() && '' != wpex_active_skin() ) {
	$wpex_skin_dir = get_template_directory() .'/skins/'. wpex_active_skin() .'/'. wpex_active_skin() .'-class.php';
	if ( file_exists( $wpex_skin_dir ) ) {
		require_once( $wpex_skin_dir );
	}
}



/*------------------------------------------------*/
/*	- WP-Updates
/*------------------------------------------------*/

// Get user envato license as provided in theme panel
$wpex_envato_license_key = wpex_option( 'envato_license_key' );

// If envato license is defined load the auto update class and pass the license to it
if ( $wpex_envato_license_key && wpex_option( 'enable_auto_updates', '0' ) ) {
	require_once( get_template_directory() .'/wp-updates-theme.php');
	new WPUpdatesThemeUpdater_479( 'http://wp-updates.com/api/2/theme', basename(get_template_directory()), $wpex_envato_license_key );
}