<?php
/**
 * Function used to display the page subheading
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/


// Page Titles
if ( ! function_exists('wpex_page_title') ) {
	
	function wpex_page_title( $title = '' ) {
		
		// Get post
		global $post, $wp_query;
		
		// Homepage - display blog description if not a static page
		if ( is_front_page() && !is_singular('page') ) {
			
			$title = get_bloginfo( 'description' );

		// Homepage posts page
		} elseif ( is_home() && !is_singular('page') ) {

			$title = get_the_title( get_option('page_for_posts', true) );
			
		// Archives
		} elseif ( is_archive() ) {
			
			// Daily archive title
			if ( is_day() ) {
				$title = sprintf( __( 'Daily Archives: %s', 'wpex' ), get_the_date() );
			
			// Monthly archive title
			} elseif ( is_month() ) {
				$title = sprintf( __( 'Monthly Archives: %s', 'wpex' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'wpex' ) ) );
				
			// Yearly archive title
			} elseif ( is_year() ) {
				$title = sprintf( __( 'Yearly Archives: %s', 'wpex' ), get_the_date( _x( 'Y', 'yearly archives date format', 'wpex' ) ) );

			// Post Type archive title
			} elseif ( is_post_type_archive() ) {

				if ( is_post_type_archive( 'product' ) ) {
					if ( class_exists( 'Woocommerce' ) && function_exists( 'wc_get_page_id' ) ) {
						$title = get_the_title( wc_get_page_id( 'shop' ) );
					} else {
						$title = __( 'Shop', 'wpex' );
					}
				} else {
					$title = post_type_archive_title('', false);
				}
			
			// Standard term title
			} else {
				$title = single_term_title( "", false );
				
				// Fix for bbPress and other plugins that are archives but use
				// Standard templates...zzz
				if ( $title == '' ) {
					$post_id = $post->ID;
					$title = get_the_title($post_id);
				}
			}
			
		// Search
		} elseif( is_search() ) {
			
			$title = '<span id="search-results-count">'. $wp_query->found_posts .'</span> '. __( 'Search Results Found', 'wpex' );
			
		// 404 Page
		} elseif ( is_404() ) { 
			
			$title = wpex_option( 'error_page_title', __( '404: Page Not Found', 'wpex') );
		
		// All else
		} else {
			$post_id = $post->ID;
			if ( is_singular( 'product' ) ) {
				$title = wpex_option( 'woo_shop_single_title', __( 'Store', 'wpex' ) );
			} else {
				$title = get_the_title($post_id);
			}
		}
		
		return $title;
		
		
	} // End function

} // End if


// Page Subheading
if ( ! function_exists('wpex_post_subheading') ) {
	
	function wpex_post_subheading() {
		
		// Vars
		global $post;
		$output='';
		
		// Posts & Pages
		if ( is_singular () ) {
			$post_id = $post->ID;
			$subheading = get_post_meta( $post_id, 'wpex_post_subheading', true );
			$output = '';
			if ( $subheading ) {
				$output .= '<div class="clr page-subheading">';
					$output .= do_shortcode( $subheading );
				$output .= '</div>';
			}
		}
		
		// Archives
		if ( is_tax() ) {
			$obj = get_queried_object();
			$taxonomy = $obj->taxonomy;
			$term_id = $obj->term_id;
			$description = term_description($term_id,$taxonomy);
			if ( ! empty( $description ) ){
				$output .= '<div class="clr page-subheading term-description">';
					$output .= $description;
				$output .= '</div>';
			}
		}
		
		// Return content
		return $output;
		
	} // End function
	
} // End if


// Page Header
if ( ! function_exists('wpex_page_header') ) {
	
	function wpex_page_header( $before='', $after='', $breadcrumbs = true ) {
		
		// Not used for author archives
		if ( is_author() ) return;

		// Disable on store
		if ( is_post_type_archive( 'product' ) && !wpex_option( 'woo_shop_title' ) ) return;
		
		
		// Vars
		global $post;
		$output=$classes=$height=$style=$title_bg=$disable_title='';
		$title_style = 'default';
		$heading = apply_filters( 'wpex_page_header_heading','h1');
		if ( $post && is_singular() ) {
			$post_id = $post->ID;
			$disable_title = get_post_meta( get_the_ID(), 'wpex_disable_title', true );
			$title = get_the_title();
		}
		$page_title = wpex_page_title();
				
		// If page header is disabled do nothing
		if ( $disable_title == 'on' ) return false;
		
		// Page meta options
		if ( is_singular ( 'page' ) || is_singular ( 'portfolio' ) || is_singular ( 'staff' ) || is_singular ( 'post' ) ) {
			
			// Get title style
			$title_style = get_post_meta( $post_id, 'wpex_post_title_style', true );
			if ( empty( $title_style ) ) {
				$title_style = wpex_option( 'page_header_style' );
			}
			
			// Background image style
			if ( $title_style == 'background-image' ) {
				
				// Get meta values
				$title_bg = get_post_meta( $post_id, 'wpex_post_title_background', true );
				$title_height = get_post_meta( $post_id, 'wpex_post_title_height', true );
				
				// Set title height
				$title_height = $title_height ? $title_height : '400';
				$title_height = intval($title_height) .'px'; // set height in pixels
			}
			
			
			// Solid Color Title Style
			if ( $title_style == 'solid-color' || $title_style == 'background-image' ) {
				
				// Get meta color option
				$title_bg_color = get_post_meta( $post_id, 'wpex_post_title_background_color', true );
				
				// Set background color in header style
				$style .='background-color: '. $title_bg_color .';';
				
			}
			
			// Custom Classes
			if ( $title_style !== 'default' && $title_style ) { 
				$classes .= $title_style .'-page-header';
			}
			
			// Header Background Image
			if ( $title_bg ) {
				$style .= ' background: url('. $title_bg .') 50% 0;-webkit-background-size: cover;-moz-background-size: cover;-o-background-size: cover;background-size: cover;height: '.$title_height.';';
			}
			
			// Disable breadcrumbs if background image set
			if ( $title_style == 'background-image' || $title_style == 'centered' || $title_style == 'centered-minimal' ) {
				$breadcrumbs = false;
			}
		
		} ?>
		
		<?php echo $before; ?>
			
			<header class="page-header <?php echo $classes; ?>" style="<?php echo $style; ?>">
				
				<div class="container clr page-header-inner">
					<?php
					//  Main header
					echo '<'. $heading .' class="page-header-title">'. $page_title .'</'. $heading .'>'; 
					
					// Function used to display the subheading defined in the meta options
					// See previous function
					echo wpex_post_subheading();
					
					// Display built-in breadcrumbs - see functions/breadcrumbs.php
					if ( ! is_front_page() && $breadcrumbs ) wpex_display_breadcrumbs(); ?>
					
 

</div><!-- .page-header-inner -->
				
				<?php
				// Header background overlay
				if ( $title_bg ) { ?>
					<span class="background-image-page-header-overlay "></span>
				<?php } ?>
					
<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/es_ES/sdk.js#xfbml=1&version=v2.3";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>

			</header><!-- .page-header -->
		
		<?php echo $after; ?>
		
	<?php
	} // End functions
	
} // End if function exists

