<?php
/*
 * Used for the search overlay
 *
 * @package WordPress
 * @subpackage Total
 * @since 1.1
*/


add_action( 'wpex_hook_header_inner', 'wpex_search_dropdown' );

if ( ! function_exists('wpex_search_dropdown') ) {
	
	function wpex_search_dropdown() {
		
		// Do nothing if the main search is disabled
		if ( wpex_option( 'main_search', '1' ) !== '1' ) return;
		
		// Only show on certain header styles
		$header_style = wpex_option( 'header_style', 'one' );
		if ( $header_style == 'one' || $header_style == 'three' ) { ?>
		
			<div id="searchform-header-replace" class="clr header-searchform-wrap">
				<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search" class="header-searchform"><input type="search" name="s" autocomplete="off" placeholder="<?php _e( 'Type then hit enter to search...', 'wpex' ); ?>" /></form>
				<span id="searchform-header-replace-close" class="fa fa-times"></span>
			</div><!-- #searchform-header_replace -->
		
		<?php	
		} // End header style check
	} // End function
	
} // End if