<?php
/**
 * Create simple social sharing buttons.
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/


if ( !function_exists( 'wpex_social_share' ) ) {

	function wpex_social_share( $postid = '' ) {
		
		// Bail
		if ( post_password_required() ) return;
		
		// Get sharing options
		$position = wpex_option('social_share_position');
		$sharing_sites = wpex_option('social_share_sites');
		$style = wpex_option('social_share_style');
		$position = wp_is_mobile() ? 'horizontal' : $position; // Only display horizontal style menu for responsive.
		
		if ( empty($sharing_sites) ) return;
		
		// Get post
		global $post;
		if ( !$post ) return;
		$postid = $postid ? $postid :$post->ID;
		$post_type = get_post_type($post);
		$meta = get_post_meta( $postid, 'wpex_disable_social', true );
		
		// If disabled show nothing
		if ( $meta == 'on' ) return;
		if ( !is_singular('post') && 'post' == $post_type && '1' != wpex_option( 'social_share_blog_entries', '1' ) ) return;
		if ( is_singular('post') && '1' != wpex_option( 'social_share_blog_posts', '1' ) ) return;
		if ( is_singular('page') && '1' != wpex_option( 'social_share_pages', '1' ) ) return;
		if ( is_singular('portfolio') && '1' != wpex_option( 'social_share_portfolio', '1' ) ) return;
		
		if ( class_exists('Woocommerce') ) {
			if ( is_singular('product') && is_woocommerce() && '1' != wpex_option( 'social_share_woo' ) ) return;
			if ( !is_singular('product') && is_woocommerce() ) return;
			if ( is_cart() || is_checkout() ) return;
		}
		
		// Vars
		$permalink = get_permalink($postid);
		$url = urlencode( $permalink );
		$title = urlencode( esc_attr( the_title_attribute( 'echo=0' ) ) );
		$summary = urlencode( wpex_get_excerpt( '40' ) );
		$img = wp_get_attachment_url( get_post_thumbnail_id($postid) );
		$source = home_url();
		$social_share_title = __( 'Please Share This', 'wpex' );
		$social_share_title = apply_filters( 'wpex_social_share_title', $social_share_title );
		$wpex_post_layout = wpex_get_post_layout_class();
		$output = '';
		
		// Tooltip Style
		if ( is_rtl() ) {
			$tooltip_class = 'tooltip-right';
		} elseif( $position == 'horizontal' ) {
			$tooltip_class = 'tooltip-up';
		} else {
			if ( $wpex_post_layout == 'left-sidebar' ) {
				$tooltip_class ='tooltip-left';
			} else {
				$tooltip_class ='tooltip-right';
			}
		}
		
		// Display heading on Boxed layout
		if( is_singular() && $position == 'horizontal' ) {
			$output .= '<div class="social-share-title theme-heading"><span>'. $social_share_title .'</span></div>';
		}
		
		// Open URL
		$output .= '<ul class="social-share-buttons position-'. $position .' style-'. $style .' clr">';
		
			foreach ( $sharing_sites as $key => $value ) {
				
				// Twitter
				if ( $key == 'twitter' && $value ) {
					
					$output .='<li class="share-twitter">';
					
						if ( $style == 'counter' ) {
							
							$output .= '<a class="twitter-share" href="http://twitter.com/share" data-url="'. $url .'" data-text="'. $title .' '. $url .'" data-count="vertical" rel="nofollow" target="_blank"></a>';
							
						} else {
							
						$output .= '<a href="http://twitter.com/share?text='. $title .'&url='. $url .'" target="_blank" title="'. __( 'Share on Twitter', 'wpex' ) .'" rel="nofollow" class="'. $tooltip_class .'"><span class="fa fa-twitter"></span>';
						if ( $position == 'horizontal' ) {
							$output .= __('tweet','wpex');
						}
						$output .= '</a>';	
						
						}
					
					$output .= '</li>';
					
				}
				
				// Facebook
				if ( $key == 'facebook' && $value ) {
					
					$output .='<li class="share-facebook">';
					
						if ( $style == 'counter' ) {
							
							$output .= ' <a href="https://www.facebook.com/inventivaclick" class="facebook-like" data-href="http://localhost/total/awesome-new-app/" data-send="false" data-layout="box_count" data-width="60" data-show-faces="false" rel="nofollow" target="_blank"></a>';
							
						} else {
							$output .= '<a href="https://www.facebook.com/inventivaclick" target="_blank" title="'. __( 'Share on Facebook', 'wpex' ) .'" rel="nofollow" class="'. $tooltip_class .'"><span class="fa fa-facebook"></span>';
							if ( $position == 'horizontal' ) {
								$output .= __('like','wpex');
							}
							$output .= '</a>';
						}
					
					$output .= '</li>';
					
				}
				
				// Google+
				if ( $key == 'google_plus' && $value ) {
					
					$output .='<li class="share-googleplus">';
					
						if ( $style == 'counter' ) {
							
							$output .= '<a href="https://plus.google.com/share?url='. $url .'" class="googleplus-one" data-size="tall" data-href="'. $url .'" rel="nofollow" target="_blank"></a>
	';
							
						} else {
							
						$output .= '<a title="'. __( 'Share on Google+', 'wpex' ) .'" rel="external" href="https://plusone.google.com/_/+1/confirm?url=' . $url . '" target="_blank" rel="nofollow" class="'. $tooltip_class .'"><span class="fa fa-google-plus"></span>';
						if ( $position == 'horizontal' ) {
							$output .= __('plus one','wpex');
						}
						$output .= '</a></li>';	
						
						}
					
					$output .= '</li>';
				}
				
				// Pinterest
				if ( $key == 'pinterest' && $value ) {
					
					$output .='<li class="share-pinterest">';
					
						if ( $style == 'counter' ) {
							
							$output .= '<a href="//www.pinterest.com/pin/create/button/?url='. $url .'&description='. $title .'" data-pin-do="buttonPin" data-pin-config="above" data-pin-height="28" class="socialite"><img src="//assets.pinterest.com/images/pidgets/pinit_fg_en_rect_white_28.png" /></a>';
							
						} else {
							$output .= '<a href="http://pinterest.com/pin/create/button/?url='. $url .'&media='. $img .'&description='. $summary .'" target="_blank" title="'. __( 'Share on Pinterest', 'wpex' ) .'" rel="nofollow" class="'. $tooltip_class .'"><span class="fa fa-pinterest"></span>';
							if ( $position == 'horizontal' ) {
								$output .= __('pin it','wpex');
							}
							$output .= '</a>';
						}
					
					$output .= '</li>';
					
				}
				
				// LinkedIn
				if ( $key == 'linkedin' && $value ) {
					
					$output .='<li class="share-linkedin">';
					
						if ( $style == 'counter' ) {
							
							$output .= '<a href="http://www.linkedin.com/shareArticle?mini=true&url='. $url .'&title='. $title .'" class="linkedin-share" data-url="'. $url .'" data-counter="top" rel="nofollow" target="_blank"></a></li>';
							
						} else {
							$output .= '<li class="share-linkedin"><a title="'. __( 'Share on LinkedIn', 'wpex' ) .'" rel="external" href="http://www.linkedin.com/shareArticle?mini=true&url='. $url .'&title='. $title .'&summary='. $summary .'&source='. $source .'" target="_blank" rel="nofollow" class="'. $tooltip_class .'"><span class="fa fa-linkedin"></span>';
							if ( $position == 'horizontal' ) {
								$output .= __('share','wpex');
							}
							$output .= '</a>';
						}
					
					$output .= '</li>';
					
				}
			
			}
			
		// Close UL
		$output .= '</ul>';
		
		// Echo the social sharing icons
		echo $output;
		
	} // End function

} // End function_exists check