@section('title',  $paginas->titulo )
@section('meta-etiquetas')
	<meta name="description" content="{{  $paginas->meta_description }}" />
	<meta name="keywords" content="{{  $paginas->meta_keywords }}"/>


	 <meta property="og:type" content="website" />
	 <meta property="og:title" content="{{ $paginas->titulo_seo }}" />
	 <meta property="og:description" content="{{  $paginas->meta_description }}" />
	 <meta property="og:url" content="http://inventivaclick.com/{{  $paginas->slug }}" />
	 <meta property="og:site_name" content="{{  $paginas->titulo_seo }}" />
	 <meta property="og:image" content="http://inventivaclick.com/images/{{  $paginas->imagen }}" />

	 <meta name="twitter:card" content="summary"/>
	 <meta name="twitter:description" content="{{  $paginas->meta_description }}"/>
	 <meta name="twitter:title" content="{{ $paginas->titulo_seo }}"/>
	<meta name="twitter:image" content="http://inventivaclick.com/images/{{  $paginas->imagen }}" />


@stop
@section('css-paginas')
	<link rel="stylesheet" href="css/blog.css">
   

 <style>
 	 {!! $paginas->style !!}
 </style>


@stop

@section('content-pages')
 
 	<section class="container">
	<div class="row">
		<div class="col-md-1"></div>
		<div class="col-md-11 ctn-general">
			
			{!! $paginas->body !!} 
			 
			<div class="content-tabs-por-per">
				<ul class="nav nav-tabs nav nav-tabs justify-content-center" id="myTab" role="tablist">
					<li class="nav-item">
					    <a class="nav-link active" id="todos-tab" data-toggle="tab" href="#todos" role="tab" aria-controls="todos" aria-selected="true">Todos</a>
					</li>
					@forelse($blog_tabs as $tabs)
					 								<li class="nav-item">
							    <a class="nav-link" id="tablog{{ $tabs->id }}-tab" data-toggle="tab" href="#tablog{{ $tabs->id }}" role="tab" aria-controls="tablog{{ $tabs->id }}" aria-selected="true">{{ $tabs->name }}</a>
							  </li>
					@empty		 
						 
					   <li class="container">
					   	Al parecer no existe ninguna categoria para tus blogs, intenta ingresar al administrador.
					   </li>
					@endforelse
					
				</ul>

				<!-- panels-->
				<div class="tab-content" id="myTabContent">
				    <!-- content list todos  -->
				   <div class="tab-pane fade show active" id="todos" role="tabpanel" aria-labelledby="todos-tab">

						<div class="container">
						<div class="row cont-blog">

			   	   			@forelse($blogs as $bls )
			   	   			 
						            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-4">
										   
										<div class="content-img">
											<a href="blog/{{ $bls->slug }}"><img src="images/{{ $bls->image}}" alt=""></a>
										  	<span class="categoria" style="background:{{ $bls['categorie']->color }};">{{ $bls['categorie']->name }}</span>	
										</div>
										<div class="resumen-post">
											<span class="title"><a href="blog/{{ $bls->slug}}">{{ $bls->title}}</a></span><br>
											<span class="autor">By {{ $bls['author']->name }} </span><br>
											<span class="fecha">{{ date('d/m/Y',strtotime($bls->created_at)) }}</span>
										</div>
									</div>
 
						    
						    @empty
						        <div class="container">
						        	Al parecer no existe ningún blog creado, intenta crear uno nuevo en el administrador.
						        </div>
						         
			   	   			@endforelse
				       </div>
				       </div>

				   </div>
				   <!-- final content todos-->

					<!-- contenidos de los otros tabs-->
					@forelse($blog_tabs as $tabs)
							  
							  <div class="tab-pane fade" id="tablog{{ $tabs->id }}" role="tabpanel" aria-labelledby="tablog{{ $tabs->id }}-tab">
							  	 
							  	 <div class="container">
						<div class="row cont-blog">

			   	   			@forelse($blogs as $bls )

			   	   			  @if($bls->category_id == $tabs->id)
								<div class="col-sm-6 col-md-6 col-lg-4 col-xl-4">
										   
									<div class="content-img">
										<a href="blog/{{ $bls->slug }}"><img src="images/blog/blog-img.png" alt=""></a>
									  	<span class="categoria" style="background:{{ $bls['categorie']->color }};">{{ $bls['categorie']->name }}</span>	
									</div>
									<div class="resumen-post">
										<span class="title">{{ $bls->title}}</span><br>
										<span class="autor">By {{ $bls['author']->name }} </span><br>
										<span class="fecha">{{ date('d/m/Y',strtotime($bls->created_at)) }}</span>
									</div>
								</div>

			   	   			  @endif
						    @empty
						        <div class="container">
						        	Al parecer no existe ningún blog creado, intenta crear uno nuevo en el administrador.
						        </div>
						         
			   	   			@endforelse
				       </div>
				       </div>
								

							  </div>

					@empty		 
						 
					   <li class="container">
					   	Al parecer no existe ninguna categoria para tus blogs, intenta ingresar al administrador.
					   </li>
					@endforelse
				   
				<!-- content list final -->
					

					
 
				</div>

				<!-- fin panels-->

			</div>
			
		</div>
	</div>
</section>

@stop