<?php
/**
	Register Shortcode
**/
if( !function_exists( 'vcex_staff_carousel_shortcode' ) ) {

	function vcex_staff_carousel_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> '',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'style'					=> 'default',
				'count'					=> '8',
				'item_width'			=> '230',
				'min_slides'			=> '1',
				'max_slides'			=> '4',
				'items_scroll'			=> 'page',
				'animation'				=> 'CSS',
				'auto_play'				=> 'false',
				'timeout_duration'		=> '5000',
				'arrows'				=> 'true',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'thumbnail_link'		=> 'post',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'title'					=> 'true',
				'excerpt'				=> 'true',
				'excerpt_length'		=> '30',
				'filter_content'		=> 'false',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=>'',
				'social'				=> '',
				'img_hover_style'		=> '',
				'img_rendering'			=> '',
			), $atts ) );
			
		$output = '';
		
		// Include categories
		$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
		$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
		$filter_cats_include = '';
		if ( $include_categories ) {
			$include_categories = explode( ',', $include_categories );
			$filter_cats_include = array();
			foreach ( $include_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'staff_category' );
				$filter_cats_include[] = $key->term_id;
			}
		}

		// Exclude categories
		$filter_cats_exclude = '';
		if ( $exclude_categories ) {
			$exclude_categories = explode( ',', $exclude_categories );
			if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
			$filter_cats_exclude = array();
			foreach ( $exclude_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'staff_category' );
				$filter_cats_exclude[] = $key->term_id;
			}
			$exclude_categories = array(
					'taxonomy'	=> 'staff_category',
					'field'		=> 'slug',
					'terms'		=> $exclude_categories,
					'operator'	=> 'NOT IN',
				);
			} else {
				$exclude_categories = '';
			}
		}

		// Start Tax Query
		if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
			$include_categories = array(
				'taxonomy'	=> 'staff_category',
				'field'		=> 'slug',
				'terms'		=> $include_categories,
				'operator'	=> 'IN',
			);
		} else {
			$include_categories = '';
		}
		
		// The Query
		$vcex_carousel_query = new WP_Query(
			array(
				'post_type'			=> 'staff',
				'posts_per_page'	=> $count,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'no_found_rows'		=> true,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		//Output posts
		if( $vcex_carousel_query->posts ) :

		// Required Scripts
		wp_enqueue_script( 'vcex-caroufredsel' );
		
		// Give caroufredsel a unique name
		$rand_num = rand(1, 100);
		$unique_carousel_id = 'caroufredsel-'. $rand_num;
		
		// Output filter JS into the footer like a WP Jedi Master
		$output .='
			<script type="text/javascript">
				jQuery(function($){
					$(window).bind("load", function() {
						$("#'. $unique_carousel_id .'").carouFredSel({
							responsive : true,
							height: "variable",
							width : "100%",
							auto : {
								play: '. $auto_play .',
								timeoutDuration : '. $timeout_duration .',
							},
							swipe : {
								onTouch: true,
								onMouse: true
							},';
							if ( $items_scroll !== 'page' ) {
								$output .= 'scroll : {
									items : '. $items_scroll .',
								},';
							}
							if ( $arrows == 'true' ) {
								$output .= 'prev : "#prev-'. $rand_num .'",';
								$output .= 'next : "#next-'. $rand_num .'",';
							}
							$output .='items : {
								width : '. intval($item_width) .',
								height: "variable",
								visible : {
									min : '. intval($min_slides) .',
									max : '. intval($max_slides) .'
								}
							}
						});
					});
					$(window).load(function(){
						$(".vcex-caroufredsel-loading").removeClass("vcex-caroufredsel-loading");
						$(".vcex-caroufredsel").animate({ opacity: 1 });
					});
				});
			</script>';
		
			$unique_id = $unique_id ? ' id="'. $unique_id .'"' : NULL;
		
			// Main wrapper div
			$output .= '<div class="vcex-caroufredsel-wrap clr vcex-caroufredsel-staff vcex-caroufredsel-'. $style .' vcex-caroufredsel-loading"'. $unique_id  .'>';
				
				$output .= '<div class="vcex-caroufredsel"><ul id="'. $unique_carousel_id .'">';
			
				// Loop through posts
				foreach ( $vcex_carousel_query->posts as $post ) :
				
					// Post VARS
					$postid = $post->ID;
					$featured_img_url = wp_get_attachment_url( get_post_thumbnail_id( $postid ) );
					$featured_img = wp_get_attachment_url( get_post_thumbnail_id( $postid ) );
					$url = get_permalink( $postid );
					$post_title = get_the_title( $postid );
					$the_content = $post->post_content;
					if ( $the_content ) {
						$the_content_stripped = strip_shortcodes($the_content);
					}
					
					// Load scripts
					if ( $thumbnail_link == 'lightbox' ) {
						wp_enqueue_script( 'vcex-magnific-popup' );
						wp_enqueue_script( 'vcex-lightbox' );
					}
					
					// Crop featured images if necessary
					$img_width = $img_width ? intval($img_width) : '9999';
					$img_height = $img_height ? intval($img_height) : '9999';
					$thumbnail_hard_crop = $img_height == '9999' ? false : true;
					$featured_img = aq_resize( $featured_img_url, $img_width, $img_height, $thumbnail_hard_crop );

					// Image rendering
					if ( $img_rendering ) {
						$img_rendering = ' vcex-image-rendering-'. $img_rendering;
					}

					// Carousel item start
					$output .= '<li class="vcex-caroufredsel-slide">';
					
						// Image hover styles
						$img_hover_style_class = $img_hover_style ? 'vcex-img-hover-parent vcex-img-hover-'. $img_hover_style : '';
					
						// Media Wrap
						if( has_post_thumbnail($postid) ) {
							$output .= '<div class="vcex-caroufredsel-entry-media '. $img_hover_style_class .' '. $img_rendering .'">';
							
								if ( $thumbnail_link == 'none' ) {
									$output .= '<img src="'. $featured_img .'" alt="'. $post_title .'" />';
								} elseif ( $thumbnail_link == 'lightbox' ) {
									$output .= '<a href="'. $featured_img_url .'" title="'. $post_title .'" class="vcex-caroufredsel-entry-img vcex-lightbox">';
										$output .= '<img src="'. $featured_img .'" alt="'. $post_title .'" />';
											if ( function_exists('wpex_get_staff_overlay') ) $output .=  wpex_get_staff_overlay();
									$output .= '</a><!-- .vcex-caroufredsel-entry-img -->';
								} else {
									$output .= '<a href="'. $url .'" title="'. $post_title .'" class="vcex-caroufredsel-entry-img">';
										$output .= '<img src="'. $featured_img .'" alt="'. $post_title .'" />';
										if ( function_exists('wpex_get_staff_overlay') ) $output .=  wpex_get_staff_overlay();
									$output .= '</a><!-- .vcex-caroufredsel-entry-img -->';
								}
								
								$output .= '</div>';
						}
						
						if ( $title == 'true' ||  $excerpt == 'true' ) {
							
							$output .= '<div class="vcex-caroufredsel-entry-details">';
									
								if ( $title == 'true' && $post_title ) {
									$centered_title = $excerpt ? '' : 'textcenter';
									$output .= '<div class="vcex-caroufredsel-entry-title '. $centered_title .'"><a href="'. $url .'" title="'. $post_title .'">'. $post_title .'</a></div>';
								}
								
								if ( $excerpt == 'true' && !empty($the_content) ) {
									if ( has_excerpt( $postid ) ) {
										$the_excerpt = $post->post_excerpt;
										$output .= '<div class="vcex-caroufredsel-entry-excerpt">'. $the_excerpt .'</div>';
									} elseif( isset($the_content_stripped) ) {
										$output .= '<div class="vcex-caroufredsel-entry-excerpt">'. wp_trim_words( $the_content_stripped, $excerpt_length ) .'</div>';
									}
									// Display social links
									if ( function_exists('wpex_get_staff_social') && $social !== 'false' ) {
										$output .= wpex_get_staff_social( $postid );
									}
									
								}
							
							$output .= '</div>';
						
						}
						
					// Close main wrap	
					$output .= '</li>';
				
				// End foreach loop
				endforeach;
				
				// End UL
				$output .= '</ul>';
				
				// Next/Prev arrows	
				if ( $arrows == 'true' ) {
					$output .= '<div id="prev-'. $rand_num .'" class="vcex-caroufredsel-prev theme-button"><span class="fa fa-chevron-left"></span></div><div id="next-'. $rand_num .'" class="vcex-caroufredsel-next theme-button"><span class="fa fa-chevron-right"></span></div>';
				}
			
			// Close main wrap
			$output .= '</div></div><div class="vcex-clear-floats"></div>';
		
		endif; // End has posts check
		
		
		// Set things back to normal
		$vcex_carousel_query = NULL;
		wp_reset_postdata();

		// Return data
		return $output; 
		
	}
}
add_shortcode("vcex_staff_carousel", "vcex_staff_carousel_shortcode");


/**
	Add to Visual Composer
**/
$vc_img_rendering_url = 'https://developer.mozilla.org/en-US/docs/Web/CSS/image-rendering';
vc_map( array(
	"name"					=> __( "Staff Carousel", 'vcex' ),
	"description"			=> __( "Recent staff posts carousel.", 'vcex' ),
	"base"					=> "vcex_staff_carousel",
	"class"					=> "vcex_staff_carousel",
	"category"				=> array(
		__( "Staff", "vcex" ),
		__( "Sliders", "vcex" )
	),
	"icon" 					=> "icon-wpb-vcex-staff_carousel",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Post Count", 'vcex' ),
			"param_name"	=> "count",
			"value"			=> "8",
			"description"	=> __( "How many posts do you wish to show.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"description"	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"description"	=> sprintf( __( 'Select how to sort retrieved posts. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )				=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")				=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Style", 'vcex' ),
			"param_name"	=> "style",
			"value"			=> array(
				__( "Default", "vcex")		=> "default",
				__( "No Margins", "vcex" )	=> "no-margins",
			),
			"description"	=> __( "Select a carousel style.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Slide Width", 'vcex' ),
			"param_name"	=> "item_width",
			"value"			=> "230",
			"description"	=> __('The width of each slide in pixels. This is used to calculate the min and max items for responsiveness. It is basic math, figure out how many items you want to display, subtract the margins (20px between each item) and you will get your item width, increase this value to display larger items on smaller devices.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Min Slides", 'vcex' ),
			"param_name"	=> "min_slides",
			"value"			=> "1",
			"description"	=> __('The minimum number of slides to be shown.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Max Slides", 'vcex' ),
			"param_name"	=> "max_slides",
			"value"			=> "4",
			"description"	=> __('The maximum number of slides to be shown.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Items To Scroll", 'vcex' ),
			"param_name"	=> "items_scroll",
			"value"			=> "page",
			"description"	=> __('The number of items to scroll at a time. Enter "page" to scroll to the first item of the previous/next "page".','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Auto Play", 'vcex' ),
			"param_name"	=> "auto_play",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex")	=> "false",
			),
			"description"	=> __('Determines whether the carousel should scroll automatically or not.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __('Timeout Duration (in milliseconds)', 'vcex'),
			"param_name"	=> "timeout_duration",
			"value"			=> "5000",
			"dependency"	=> Array('element'	=> "auto_play", 'value' => "true" ),
			"description"	=> __('The amount of milliseconds the carousel will pause.','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Next/Prev Arrows?", 'vcex' ),
			"param_name"	=> "arrows",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex")	=> "false",
			),
			"description"	=> __( "Display the next and previous arrows?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Image Crop Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Enter a width in pixels.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Image Crop Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "9999",
			"description"	=> __( 'Enter a height in pixels. Set to "9999" to disable vertical cropping and keep image proportions.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Links To", 'vcex' ),
			"param_name"	=> "thumbnail_link",
			"value"			=> array(
				__( "Post", "vcex")			=> "post",
				__( "Lightbox", "vcex" )	=> "lightbox",
				__( "None", "vcex" )		=> "none",
			),
			"description"	=> __( "Where should the carousel images link to?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "CSS3 Image Hover", 'vcex' ),
			"param_name"	=> "img_hover_style",
			"value"			=> vcex_image_hovers(),
			"description"	=> __("Select your preferred image hover effect. Please note this will only work if the image links to a URL or a large version of itself. Please note these effects may not work in all browsers.", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Filter", 'vcex' ),
			"param_name"	=> "img_filter",
			"value"			=> vcex_image_filters(),
			"description"	=> __( "Select an image filter style.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Rendering", 'vcex' ),
			"param_name"	=> "img_rendering",
			"value"			=> vcex_image_rendering(),
			"description"	=> sprintf( __( 'Image-rendering CSS property provides a hint to the user agent about how to handle its image rendering. For example when scaling down images they tend to look a bit fuzzy in Firefox, setting image-rendering to crisp-edges can help make the images look better. <a href="%s">Learn more</a>.', 'vcex' ), esc_url( $vc_img_rendering_url ) )
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Title", 'vcex' ),
			"param_name"	=> "title",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post tiles?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Excerpt", 'vcex' ),
			"param_name"	=> "excerpt",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( 'Display post excerpts?', 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Excerpt Length", 'vcex' ),
			"param_name"	=> "excerpt_length",
			"value"			=> "30",
			"dependency"	=> Array(
				'element'	=> "excerpt",
				'value'		=> "true"
			),
			"description"	=> __( 'Enter a custom excerpt length. Will trim the excerpt by this number of words', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Social Links", 'vcex' ),
			"param_name"	=> "social",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( 'Display social links?', 'vcex' ),
		),
	)
) );
?>