@extends('master.theme-page')

@foreach($blog as $blometa)
    @section('title',  $blometa->title )
	@section('meta-etiquetas')
		<meta name="description" content="{{  $blometa->meta_description }}" />
		<meta name="keywords" content="{{  $blometa->meta_keywords }}"/>


		 <meta property="og:type" content="website" />
		 <meta property="og:title" content="{{ $blometa->seo_title }}" />
		 <meta property="og:description" content="{{  $blometa->meta_description }}" />
		 <meta property="og:url" content="http://inventivaclick.com/{{  $blometa->slug }}" />
		 <meta property="og:site_name" content="{{  $blometa->seo_title }}" />
		 <meta property="og:image" content="http://inventivaclick.com/images/{{  $blometa->image }}" />

		 <meta name="twitter:card" content="summary"/>
		 <meta name="twitter:description" content="{{  $blometa->meta_description }}"/>
		 <meta name="twitter:title" content="{{ $blometa->seo_title }}"/>
		<meta name="twitter:image" content="http://inventivaclick.com/images/{{  $blometa->image }}" />


	@stop


@endforeach

@section('css-paginas')

   <link rel="stylesheet" href="../css/blog_interno.css">

 <style>
 	 
 </style>


@stop

@section('content-pages')

   @foreach($blog as $b)

   <div class="container">
   	<div class="row">
   		<div class="col-md-1"></div>
   		<div class="col-md-11">
   			<div class="title-blog">
		   		<h1>{!! $b->title  !!}</h1>
			</div>
			<div class="date-details">
				<i class="fa fa-clock-o" aria-hidden="true"></i> <span class="date-blog">{{ date('d/m/Y',strtotime($b->created_at)) }}</span>

			</div>
			<div class="img-blog">
				<img src="../images/{{ $b->image }}" alt="">
			</div>
			<div class="container-body-blog">
				{!! $b->body  !!}
			</div>
		   	
   		</div>
   	</div>
   </div>

		
  @endforeach

 
@stop