<?php
/**
	Add Portfolio Grid Shortcode
**/
if( !function_exists( 'vcex_portfolio_grid_shortcode' ) ) {

	function vcex_portfolio_grid_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> '',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'posts_per_page'		=> '12',
				'grid_style'			=> 'fit_columns',
				'columns'				=> '4',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'filter'				=> '',
				'thumbnail_link'		=> 'post',
				'img_crop'				=> 'true',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'thumb_link'			=> 'post',
				'img_filter'			=> '',
				'title'					=> 'true',
				'excerpt'				=> 'true',
				'excerpt_length'		=> '30',
				'read_more'				=> 'false',
				'read_more_text'		=> __( 'read more', 'vcex' ),
				'pagination'			=> 'false',
				'filter_content'		=> 'false',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=> '',
				'img_hover_style'		=> '',
				'img_overlay_disable'	=> '',
				'img_rendering'			=> '',
				'all_text'				=> __( 'All', 'wpex' ),
			), $atts));
			
		// Get global $post
		global $post;

		// Don't create custom tax if tax doesn't exist
		if ( taxonomy_exists( 'portfolio_category' ) ) {

			// Include categories
			$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
			$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
			$filter_cats_include = '';
			if ( $include_categories ) {
				$include_categories = explode( ',', $include_categories );
				$filter_cats_include = array();
				foreach ( $include_categories as $key ) {
					$key = get_term_by( 'slug', $key, 'portfolio_category' );
					$filter_cats_include[] = $key->term_id;
				}
			}

			// Exclude categories
			$filter_cats_exclude = '';
			if ( $exclude_categories ) {
				$exclude_categories = explode( ',', $exclude_categories );
				if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
				$filter_cats_exclude = array();
				foreach ( $exclude_categories as $key ) {
					$key = get_term_by( 'slug', $key, 'portfolio_category' );
					$filter_cats_exclude[] = $key->term_id;
				}
				$exclude_categories = array(
						'taxonomy'	=> 'portfolio_category',
						'field'		=> 'slug',
						'terms'		=> $exclude_categories,
						'operator'	=> 'NOT IN',
					);
				} else {
					$exclude_categories = '';
				}
			}
			
			// Start Tax Query
			if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
				$include_categories = array(
					'taxonomy'	=> 'portfolio_category',
					'field'		=> 'slug',
					'terms'		=> $include_categories,
					'operator'	=> 'IN',
				);
			} else {
				$include_categories = '';
			}

		}
		
		// Pagination var
		if( $pagination == 'true' ) {
			global $paged;
			$paged = get_query_var('paged') ? get_query_var('paged') : 1;
		} else {
			$paged = NULL;
		}
		
		// The Query
		$vcex_query = new WP_Query(
			array(
				'post_type'			=> 'portfolio',
				'posts_per_page'	=> $posts_per_page,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'paged'				=> $paged,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		//Output posts
		if( $vcex_query->posts ) :
			$unique_id = $unique_id ? $unique_id : 'portfolio-'. rand( 1, 100 );
			$img_crop = $img_crop == 'true' ? true : false;
			$read_more = $read_more == 'true' ? true : false;
			
			// Set correct grid class
			$col_class = 'span_8';
			if ( $columns == '1' ) $col_class = 'span_1_of_1';
			if ( $columns == '2' ) $col_class = 'span_1_of_2';
			if ( $columns == '3' ) $col_class = 'span_1_of_3';
			if ( $columns == '4' ) $col_class = 'span_1_of_4';
			if ( $columns == '5' ) $col_class = 'span_1_of_5';
			if ( $columns == '6' ) $col_class = 'span_1_of_6';
			if ( $columns == '7' ) $col_class = 'span_1_of_7';
			if ( $columns == '8' ) $col_class = 'span_1_of_8';
			if ( $columns == '9' ) $col_class = 'span_1_of_9';
			if ( $columns == '10' ) $col_class = 'span_1_of_10';
			if ( $columns == '11' ) $col_class = 'span_1_of_11';
			if ( $columns == '12' ) $col_class = 'span_1_of_12';
			
			// Looad lightbox scripts
			if ( $thumb_link == 'lightbox' ) {
				wp_enqueue_script( 'vcex-magnific-popup' );
				wp_enqueue_script( 'vcex-lightbox' );
			}
			
			// Remove all filter/isotope for no margin grids
			if ( $grid_style == 'no_margins' ) {
				$filter = false;
			}
			
			// Load Masonry scripts
			if ( $filter == 'true' || $grid_style == 'masonry' || $grid_style == 'no_margins' ) {
				wp_enqueue_script( 'vcex-isotope' ); // Load Isotope Script
			}
			
			ob_start(); ?>
				<?php
				// Display filter links
				if ( $filter == 'true' && taxonomy_exists( 'portfolio_category' ) ) {
					$terms = get_terms( 'portfolio_category', array(
						'include'	=> $filter_cats_include,
						'exclude'	=> $filter_cats_exclude,
					) );
					$terms = apply_filters( 'vcex_portfolio_grid_get_terms', $terms );
					if( $terms ) { ?>
						<ul class="vcex-portfolio-filter filter-<?php echo $unique_id; ?> vcex-filter-links clr">
							<li class="active"><a href="#" data-filter="*"><span><?php echo $all_text; ?></span></a></li>
							<?php foreach ($terms as $term ) : ?>
								<li><a href="#" data-filter=".cat-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></a></li>
							<?php endforeach; ?>
						</ul><!-- .vcex-portfolio-filter -->
					<?php } ?>
				<?php } ?>
				
				<?php
				if ( $filter == 'true' || $grid_style == 'masonry' ) { ?>
				<script type="text/javascript">
				jQuery(function($){
					$(window).load(function() {
							function wpexPortfolioIsotope() {
								var $container = $('#<?php echo $unique_id; ?>');
								$container.isotope({
									itemSelector: '.portfolio-entry'
								});
							} wpexPortfolioIsotope();
							var $filterLinks = $('.filter-<?php echo $unique_id; ?> a');
							$filterLinks.each( function() {
								var $filterableDiv = $(this).data('filter');
								if ( $filterableDiv == '*' ) {
									// ignore this one
								} else {
									if ( $($filterableDiv).width() ) {
										// keep these
									} else {
										// remove these
										$(this).parent().hide();
									}
								}
							});
							$filterLinks.css({ opacity: 1 } );
							$filterLinks.click(function(){
							var selector = $(this).attr('data-filter');
								$('#<?php echo $unique_id; ?>').isotope({ filter: selector });
								$(this).parents('ul').find('li').removeClass('active');
								$(this).parent('li').addClass('active');
							return false;
							});
							var isIE8 = $.browser.msie && +$.browser.version === 8;
							if (isIE8) {
								document.body.onresize = function () {
									wpexPortfolioIsotope();
								};
							} else {
								$(window).resize(function () {
									wpexPortfolioIsotope();
								});
							}
							window.addEventListener("orientationchange", function() {
								wpexPortfolioIsotope();
							});
					});
				});
				</script>
				<?php } ?>
				
				<?php
				// No margins grid scripts and JS
				if ( $grid_style == 'no_margins' ) {
					// Enqueue Scripts
					wp_enqueue_script('masonry'); ?>
					<script type="text/javascript">
					jQuery(function($){
						var $container = $('#<?php echo $unique_id; ?>');
						$container.imagesLoaded( function() {
							$container.masonry({
								itemSelector: ".portfolio-entry"
							});
						});
					});
					</script>
				<?php } ?>

				<?php
				// Main wrap classes
				$wrap_classes = 'wpex-row vcex-portfolio-grid';
				$wrap_classes .= ' vcex-clearfix';
				if ( 'true' == $filter  || 'masonry' == $grid_style || 'no_margins' == $grid_style ) {
					$wrap_classes .= ' vcex-masonry-grid';
				}
				if ( $grid_style == 'no_margins' ) {
					$wrap_classes .= ' vcex-no-margin-grid';
				} ?>
		
				<div class="<?php echo $wrap_classes; ?>" id="<?php echo $unique_id; ?>">
					<?php
					// Define counter var to clear floats
					$count='';
					// Start loop
					foreach ( $vcex_query->posts as $post ) : setup_postdata( $post );
						// Define post ID var
						$post_id = $post->ID;
						// Add to the counter var
						$count++;
						// Add classes to the entries
						$entry_classes = 'portfolio-entry col';
						// Image rendering
						if ( $img_rendering ) {
							$entry_classes .= ' vcex-image-rendering-'. $img_rendering;
						}
						// Main column class
						$entry_classes .= ' '. $col_class;
						// Counter to clear divs
						$entry_classes .= ' col-'. $count;
						// Add category slugs to classes
						if ( taxonomy_exists( 'portfolio_category' ) ) {
							$post_terms = get_the_terms( $post, 'portfolio_category' );
							if ( $post_terms ) {
								foreach ( $post_terms as $post_term ) {
									$entry_classes .= ' cat-'. $post_term->term_id;
								}
							}
						} ?>
						<article id="#post-<?php the_ID(); ?>" class="<?php echo $entry_classes; ?>">
							<?php
							// Video
							if ( function_exists( 'wpex_get_portfolio_featured_video_url' ) && wpex_get_portfolio_featured_video_url() ) {
								wpex_portfolio_post_video();
							}
							// Featured Image
							elseif ( has_post_thumbnail() ) {
								// Filter style
								$img_filter_class = $img_filter ? 'vcex-'. $img_filter : '';
								// Image hover styles
								$img_hover_style_class = $img_hover_style ? 'vcex-img-hover-parent vcex-img-hover-'. $img_hover_style : ''; ?>
								<div class="portfolio-entry-media <?php echo $img_filter_class; ?> <?php echo $img_hover_style_class; ?>">
									<?php if ( $thumb_link == 'post' ||  $thumb_link == 'lightbox' ) { ?>
										<?php if ( $thumb_link == 'post' ) { ?>
											<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
										<?php } ?>
										<?php if ( $thumb_link == 'lightbox' ) { ?>
											<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="vcex-lightbox">
										<?php } ?>
									<?php } ?>
										<img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id() ), intval($img_width), intval($img_height), $img_crop ); ?>" alt="<?php the_title(); ?>" class="portfolio-entry-img" />
									<?php if ( $thumb_link == 'post' ||  $thumb_link == 'lightbox' ) { ?>
										<?php if ( $img_overlay_disable !== 'yes' ) { ?>
											<span class="portfolio-entry-overlay"></span>
										<?php } ?>
										</a>
								<?php } ?>
							</div><!-- .portfolio-entry-media -->
							<?php } ?>
							<?php if ( $title == 'true' || $excerpt == 'true' ) { ?>
								<div class="portfolio-entry-details clr">
									<?php if ( $title == 'true' ) { ?>
										<h2 class="portfolio-entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
									<?php } ?>
									<?php if ('true' ==  $excerpt  || 'true' == $read_more ) {
										if ( 'true' != $excerpt ){
											$excerpt_length = '0';
										} ?>
										<div class="portfolio-entry-excerpt clr">
											<?php if ( '9999' == $excerpt_length  ) {
												the_content();
											} else {
												vcex_excerpt( $excerpt_length, $read_more, $read_more_text );
											} ?>
										</div>
									<?php } ?>
								</div><!-- .portfolio-entry-details -->
							<?php } ?>
						</article><!-- .portfolio-entry -->
					<?php
					// Reset counter
					if ( $count == $columns ) {
						$count = '';
					} ?>
					<?php endforeach; ?>
				</div><!-- .vcex-portfolio-grid -->
				
				<?php
				// Paginate Posts
				if( $pagination == 'true' ) {
					$total = $vcex_query->max_num_pages;
					$big = 999999999; // need an unlikely integer
					if( $total > 1 )  {
						if( !$current_page = get_query_var('paged') )
							 $current_page = 1;
						if( get_option('permalink_structure') ) {
							 $format = 'page/%#%/';
						} else {
							 $format = '&paged=%#%';
						}
						echo paginate_links(array(
							'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format'		=> $format,
							'current'		=> max( 1, get_query_var('paged') ),
							'total'			=> $total,
							'mid_size'		=> 2,
							'type'			=> 'list',
							'prev_text'		=> '<i class="fa fa-angle-left"></i>',
							'next_text'		=> '<i class="fa fa-angle-right"></i>',
						) );
					}
				}
			
			endif; // End has posts check
					
			// Set things back to normal
			wp_reset_postdata();
		
		return ob_get_clean();
		
	}
	add_shortcode( "vcex_portfolio_grid", "vcex_portfolio_grid_shortcode" );
}




/**
	Add to Visual Composer
**/
$vc_img_rendering_url = 'https://developer.mozilla.org/en-US/docs/Web/CSS/image-rendering';
vc_map( array(
	"name"					=> __( "Portfolio Grid", 'vcex' ),
	"description"			=> __( "Recent portfolio posts grid.", 'vcex' ),
	"base"					=> "vcex_portfolio_grid",
	"class"					=> "vcex_portfolio_grid",
	"category"				=> __( "Portfolio", "vcex" ),
	"icon" 					=> "icon-wpb-vcex-portfolio_grid",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"description"	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"description"	=> sprintf( __( 'Select how to sort retrieved posts. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )				=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")				=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Columns", 'vcex' ),
			"param_name"	=> "columns",
			"value" 		=> array(
				__('Four','vcex')	=>'4',
				__('Three','vcex')	=>'3',
				__('Two','vcex')	=>'2',
				__('One','vcex')	=>'1',
			),
			"description"	=> __('Select how many columns for the grid.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Posts Per Page", 'vcex' ),
			"param_name"	=> "posts_per_page",
			"value"			=> "8",
			"description"	=> __( "How many posts do you wish to show?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Pagination", 'vcex' ),
			"param_name"	=> "pagination",
			"value"			=> array(
				__( "No", "vcex")	=> "false",
				__( "Yes", "vcex" )	=> "true",
			),
			"description"	=> __("Paginate posts? Important: Pagination will not work on your homepage because of how WordPress works","vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Grid Style", 'vcex' ),
			"param_name"	=> "grid_style",
			"value"			=> array(
				__( "Fit Columns", "vcex")					=> "fit-columns",
				__( "Masonry (Filter allowed)", "vcex" )	=> "masonry",
				__( "No Margins", "vcex" )					=> "no_margins",
			),
			"description"	=> __( 'Select a grid style. If you select no margins be sure to crop your featured images to the same dimensions.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Category Filter", 'vcex' ),
			"param_name"	=> "filter",
			"value"			=> array(
				__( "Yes", "vcex")	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Do you wish to display an animated category filter?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( 'Custom Category Filter "All" Text', 'vcex' ),
			"param_name"	=> "all_text",
			"value"			=> "",
			"description"	=> __( 'Custom text for the "all" button in the category filter.', 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "filter",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Image Crop Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping width. Enter 9999 for no cropping.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Image Crop Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping height. Enter 9999 for no cropping (just resizing).", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Filter", 'vcex' ),
			"param_name"	=> "img_filter",
			"value"			=> vcex_image_filters(),
			"description"	=> __( "Select a custom filter style for your images.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Rendering", 'vcex' ),
			"param_name"	=> "img_rendering",
			"value"			=> vcex_image_rendering(),
			"description"	=> sprintf( __( 'Image-rendering CSS property provides a hint to the user agent about how to handle its image rendering. For example when scaling down images they tend to look a bit fuzzy in Firefox, setting image-rendering to crisp-edges can help make the images look better. <a href="%s">Learn more</a>.', 'vcex' ), esc_url( $vc_img_rendering_url ) )
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "CSS3 Image Hover", 'vcex' ),
			"param_name"	=> "img_hover_style",
			"value"			=> vcex_image_hovers(),
			"description"	=> __("Select your preferred image hover effect. Please note this will only work if the image links to a URL or a large version of itself. Please note these effects may not work in all browsers.", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Links To", 'vcex' ),
			"param_name"	=> "thumb_link",
			"value"			=> array(
				__( "Post", "vcex")			=> "post",
				__( "Lightbox", "vcex" )	=> "lightbox",
				__( "Nowhere", "vcex" )		=> "nowhere",
			),
			"description"	=> __( "Default link behaviour on the images.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Overlay?", 'vcex' ),
			"param_name"	=> "img_overlay_disable",
			"value"			=> array(
				__( "True", "vcex" )	=> "",
				__( "False", "vcex")	=> "yes",
			),
			"description"	=> __("Display the default overlay when a user hovers over the featured image?", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Title", 'vcex' ),
			"param_name"	=> "title",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post title?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Excerpt", 'vcex' ),
			"param_name"	=> "excerpt",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Excerpt Length", 'vcex' ),
			"param_name"	=> "excerpt_length",
			"value"			=> "",
			"dependency"	=> Array(
				'element'	=> "excerpt",
				'value'		=> "true"
			),
			"description"	=> __( 'Enter a custom excerpt length. Will trim the excerpt by this number of words. Enter "9999" to display the_content instead of the auto excerpt.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Read More", 'vcex' ),
			"param_name"	=> "read_more",
			"value"			=> array(
				__( "No", "vcex" )	=> "false",
				__( "Yes", "vcex")		=> "true",
			),
			"description"	=> __( "Display post readmore button after excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Read More Text", 'vcex' ),
			"param_name"	=> "read_more_text",
			"value"			=> "",
			"description"	=> __("Enter your custom text for the readmore button.","vcex"),
			"dependency"	=> Array(
				'element'	=> "read_more",
				'value'		=> "true"
			),
		),
	)
) );