<?php
/**
 * Used for your standard post entry content and single post media
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
 */


/******************************************************
 * Single Posts
*****************************************************/

if ( is_singular() ) { ?>
	
	<?php if( '1' == wpex_option('blog_single_thumbnail', '1' ) && has_post_thumbnail() ) { ?>
		<div id="post-media" class="clr">
			<img src="<?php echo wpex_get_featured_image_url(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" />
		</div><!-- #post-media -->
	<?php } ?>


<?php
}
/******************************************************
 * Entries
*****************************************************/
else {
	$wpex_class = ( 'post' == get_post_type() ) ? 'blog' : 'custom-posttype'; ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php
		// Display the post thumbnail if one is set and the post is not password protected
		if ( has_post_thumbnail() && ! post_password_required() ) { ?>
			<div class="<?php echo $wpex_class; ?>-entry-media">
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" class="<?php echo $wpex_class; ?>-entry-media-link <?php wpex_img_animation_classes(); ?>"><img src="<?php echo wpex_get_featured_image_url(); ?>" alt="<?php echo the_title(); ?>" /></a>
			</div><!-- .<?php echo $wpex_class; ?>-entry-media -->
		<?php } ?>
		<div class="<?php echo $wpex_class; ?>-entry-content clr">
			<header class="clr <?php if ( wpex_post_entry_author_avatar_enabled() ) { echo 'header-with-avatar'; } ?>">
				<h2 class="<?php echo $wpex_class; ?>-entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
				<?php
				// Displays the post entry author avatar - see functions/post-entry-author-avatar.php
				wpex_post_entry_author_avatar();
				
				// Display post meta - see functions/post-meta.php
				wpex_post_meta(); ?>
			</header>
			<div class="<?php echo $wpex_class; ?>-entry-excerpt entry">
				<?php
				// Display excerpt if auto excerpts are enavled in the admin
				if ( '1' == wpex_option( 'blog_exceprt', '1' ) ) {
					// Get excerpt length & output excerpt
					// See functions/excerpts.php
					$wpex_excerpt_length = wpex_excerpt_length();
					wpex_excerpt( $wpex_excerpt_length );
				} else {
				// Display full content
					the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'wpex' ) );
				} ?>
			</div><!-- .<?php echo $wpex_class; ?>-entry-excerpt -->
			<?php
			// Read more link - see functions/post-readmore-link.php
			wpex_post_readmore_link();
			// Social sharing links
			wpex_social_share(); ?>
		</div><!-- .<?php echo $wpex_class; ?>-entry-content -->
	</article><!-- .<?php echo $wpex_class; ?>-entry-entry -->
<?php } ?>