<?php
/**
 * This file loads css and js for our theme and other script related functions
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/


// Load all CSS & JS for the theme
add_action( 'wp_enqueue_scripts', 'wpex_load_scripts' );

if ( ! function_exists( 'wpex_load_scripts' ) ) {
	
	function wpex_load_scripts() {
		
		
		/*******
		*** CSS
		*******************/
		
		// Load Visual composer CSS at top of site
		if ( function_exists( 'vc_map' ) && !is_admin() ) {
			wp_enqueue_style( 'js_composer_front' );
		}
		
		// Main css
		wp_enqueue_style( 'wpex-style', get_stylesheet_uri() );
		
		// Font awesome icons
		wp_enqueue_style( 'wpex-font-awesome', WPEX_CSS_DIR_UIR .'font-awesome.min.css', array( 'wpex-style' ) );
		
		// WooCommerce
		if ( class_exists('Woocommerce') ) {
			wp_enqueue_style( 'wpex-woocommerce', WPEX_CSS_DIR_UIR .'woocommerce.css' );
		}
		
		// Responsive
		if( wpex_option( 'responsive', '1' ) ) {
			wp_enqueue_style( 'wpex-responsive', WPEX_CSS_DIR_UIR .'responsive.css', array( 'wpex-style' ) );
		}

		/*******
		*** jQuery
		*******************/
		
		// Add scripts
		wp_enqueue_script( 'jquery' );
		if ( wpex_option( 'retina', '1' ) == '1' ) {
			wp_enqueue_script('retina', WPEX_JS_DIR_URI .'retina.js', array('jquery'), '0.0.2', true);
		}
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script('comment-reply');
		} 
		wp_enqueue_script( 'wpex-plugins', WPEX_JS_DIR_URI .'plugins.js', array( 'jquery' ), '1.0', true);
		wp_enqueue_script( 'wpex-global', WPEX_JS_DIR_URI .'global.js', array( 'jquery', 'wpex-plugins' ), '1.0', true);
		
		// Remove JS
		wp_deregister_script( 'flexslider' );
		wp_deregister_script( 'vcex-flexslider' );
		wp_deregister_script( 'vcex-isotope' );
		wp_deregister_script( 'vcex-magnific-popup' );
		wp_deregister_script( 'vcex-isotope' );
		
	} // End function

} // End if


// Load HTML5 js for old IE browsers
if ( !function_exists('wpex_html5') ) {
	function wpex_html5() {
		echo '<!--[if lt IE 9]>
			<script src="'.WPEX_JS_DIR_URI .'html5.js"></script>
		<![endif]-->';
	} // End function
} // End if
add_action('wp_head', 'wpex_html5');



// Remove script versions if enabled
if ( ! function_exists( 'wpex_remove_wp_ver_css_js' ) ) {
	function wpex_remove_wp_ver_css_js( $src ) {
	if ( wpex_option( 'remove_scripts_version', '1' ) ) {
		if ( strpos( $src, 'ver=' ) ) {
			$src = remove_query_arg( 'ver', $src );
		}
	}
	return $src;
	} // End function
} // End if
add_filter( 'style_loader_src', 'wpex_remove_wp_ver_css_js', 9999 );
add_filter( 'script_loader_src', 'wpex_remove_wp_ver_css_js', 9999 );