<?php
/**
 * Returns the correct sidebar region
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/

if ( ! function_exists( 'wpex_get_sidebar' ) ) {
	
	function wpex_get_sidebar( $sidebar='sidebar' ) {
		
		// Custom Post Types
		$post_types = wpex_active_post_types();
		foreach ( $post_types as $post_type ) {
			if ( is_singular( $post_type ) || is_tax( $post_type .'_category' ) || is_tax( $post_type .'_tag' ) ) {
				if ( wpex_option( $post_type .'_custom_sidebar', '1' ) ) {
					return $post_type .'_sidebar';
				}
			}
		}
		
		// WooCommerce
		if ( class_exists( 'Woocommerce' ) ) {
			if ( wpex_option( 'woo_custom_sidebar', '1' ) && is_woocommerce() ) {
				return 'woo_sidebar';
			}
		}
		
		// bbPress
		if ( function_exists('is_bbpress') ) {
			if ( is_bbpress() && wpex_option( 'bbpress_custom_sidebar', '1' ) ) {
				return 'bbpress_sidebar';
			}
		}

		// Pages
		if ( is_page() && wpex_option( 'pages_custom_sidebar', '1' ) ) {
			if ( !is_page_template('templates/blog.php') ) {
				return 'pages_sidebar';
			}
		}
		
		// Return the correct sidebar name & add useful hook
		return apply_filters( 'wpex_get_sidebar', $sidebar );
		
	} // End function
	
} // End if