<?php
/**
 * Outputs the Viewport for the site
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.1
*/


if ( ! function_exists( 'wpex_meta_viewport' ) ) {
	function wpex_meta_viewport() {
		// Responsive
		if( wpex_option( 'responsive', '1' ) == '1' ) {
			$output = '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />';
		// Non responsive
		} else {
			$output = '<meta name="viewport" content="width='. intval(wpex_option( 'main_container_width', '980' )) .'" />';
		}
		// Return meta
		echo $output;
		
	} // End function
} // End if