<?php
/**
	Register Shortcode
**/
if( !function_exists('vcex_testimonials_slider_shortcode') ) {
	function vcex_testimonials_slider_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'count'					=> '3',
			'term_slug'				=> '',
			'include_categories'	=> '',
			'exclude_categories'	=> '',
			'category'				=> 'all',
			'order'					=> 'DESC',
			'orderby'				=> 'date',
			'skin'					=> 'light',
			'font_size'				=> '',
			'font_weight'			=> '',
			'background'			=> '',
			'background_image'		=> '',
			'background_style'		=> 'stretch',
			'css_animation'			=> '',
			'filter_content'		=> 'false',
			'offset'				=> 0,
			'unique_id'				=> '',
			'slideshow'				=> 'true',
			'slideshow_speed'		=> '7000',
			'animation_speed'		=> '600',
			'display_author_name'	=> 'false',
			'display_author_avatar'	=> 'false',
		), $atts ) );
		
		// Animation
		$css_animation_classes = '';
		if ( $css_animation !== '' ) {
			$css_animation_classes = 'wpb_animate_when_almost_visible wpb_'. $css_animation .'';
		}
		
		// Background image
		$background_image_style = '';
		if ( $background_image !== '' ) {
			$img_url = wp_get_attachment_url($background_image);
			$background_image_style = 'background-image: url('. $img_url .');';
		}
		
		if ( $background_style == 'parallax' ) {
			 wp_enqueue_script( 'vcex-parallax' );
		}

		// Slide Style
		$slide_style = array();

		if ( $font_size ) {
			$slide_style[] = 'font-size: '. $font_size .';';
		}
		
		if ( $font_weight ) {
			$slide_style[] = 'font-weight: '. $font_weight .';';
		}

		$slide_style = implode('', $slide_style);

		if ( $slide_style ) {
			$slide_style = wp_kses( $slide_style, array() );
			$slide_style = ' style="' . esc_attr($slide_style) . '"';
		}

		// Get post meta to check page layout
		if ( is_singular() ) {
			global $post;
			$post_id = $post->ID;
			$post_layout = get_post_meta( $post_id, 'wpex_post_layout', true );
		} else {
			$post_layout = '';
		}
		$inner_slide_container = ( 'full-screen' == $post_layout ) ? 'container' : '';
		
		// Include categories
		$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
		$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
		$filter_cats_include = '';
		if ( $include_categories ) {
			$include_categories = explode( ',', $include_categories );
			$filter_cats_include = array();
			foreach ( $include_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'testimonials_category' );
				$filter_cats_include[] = $key->term_id;
			}
		}

		// Exclude categories
		$filter_cats_exclude = '';
		if ( $exclude_categories ) {
			$exclude_categories = explode( ',', $exclude_categories );
			if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
			$filter_cats_exclude = array();
			foreach ( $exclude_categories as $key ) {
				$key = get_term_by( 'slug', $key, 'testimonials_category' );
				$filter_cats_exclude[] = $key->term_id;
			}
			$exclude_categories = array(
					'taxonomy'	=> 'testimonials_category',
					'field'		=> 'slug',
					'terms'		=> $exclude_categories,
					'operator'	=> 'NOT IN',
				);
			} else {
				$exclude_categories = '';
			}
		}
		
		// Start Tax Query
		if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
			$include_categories = array(
				'taxonomy'	=> 'testimonials_category',
				'field'		=> 'slug',
				'terms'		=> $include_categories,
				'operator'	=> 'IN',
			);
		} else {
			$include_categories = '';
		}
		
		// The Query
		$vcex_testimonials_query = new WP_Query(
			array(
				'post_type'			=> 'testimonials',
				'posts_per_page'	=> $count,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'no_found_rows'		=> true,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		$output = '';

		//Output posts
		if( $vcex_testimonials_query->posts ) :
		
			$unique_id = $unique_id ? ' id="'. $unique_id .'"' : NULL;
			
			// Give flexslider a unique name
			$rand_num = rand(1, 100);
			$unique_flexslider_id	= 'flexslider-'. $rand_num;
			
			// Load Flexslider script
			wp_enqueue_script( 'vcex-flexslider' );
			
			// Output filter JS into the footer like a WP Jedi Master
			$output .='
				<script type="text/javascript">
					jQuery(function($){
						$(window).load(function() {
							$(".vcex-flexslider-wrap").removeClass("flexslider-loader");
							$("#'. $unique_flexslider_id .'").flexslider({
								animation: "fade",
								slideshow : '. $slideshow .',
								slideshowSpeed: '. $slideshow_speed .',
								animationSpeed: '. $animation_speed .',
								controlNav : true,
								directionNav: false,
								pauseOnHover: true,
								smoothHeight: true,
								prevText : \'<i class=icon-angle-left"></i>\',
								nextText : \'<i class="icon-angle-right"></i>\',
								controlsContainer: ".vcex-slider-container-'. $rand_num .'"
							});
						});
					});
				</script>';
			
			$css_animation_classes = '';
			if ( $css_animation !== '' ) {
				$css_animation_classes = 'wpb_animate_when_almost_visible wpb_'. $css_animation .'';
			}
		
			// Main wrapper div
			$output .= '<div class="vcex-testimonials-fullslider vcex-flexslider-wrap '. $skin .'-skin vcex-background-'. $background_style .' '. $css_animation_classes .' vcex-slider-container-'. $rand_num .'"'. $unique_id .'  style="background-color: '. $background .';'. $background_image_style .'">';
			
				$output .= '<div id="'. $unique_flexslider_id .'" class="flexslider">';
				
					$output .= '<ul class="slides">';
				
						// Loop through posts
						foreach ( $vcex_testimonials_query->posts as $post ) :
						
							// Post VARS
							$postid = $post->ID;
							$post_title = get_the_title($postid);
							$post_content = $post->post_content;
							$author_name = get_post_meta( $postid, 'wpex_testimonial_author', true );
				
							// Testimonial start
							if ( '' != $post_content || '' != $custom_excerpt ) {
								$output .= '<li class="slide">';
									$output .= '<article id="post-'. $postid .'" class="vcex-testimonials-fullslider-entry '. $inner_slide_container  .'" '. $slide_style .'>';
										// Author avatar
										if ( 'yes' == $display_author_avatar && has_post_thumbnail($postid) ) {
											$post_thumb_id = get_post_thumbnail_id($postid);
											$attachment_url = wp_get_attachment_url( $post_thumb_id );
											if ( function_exists('aq_resize') ) {
												$img_url = aq_resize( $attachment_url, '70', '70', true );
											} else {
												$img_url = $attachment_url;
											}
											$output .= '<div class="vcex-testimonials-fullslider-avatar"><img src="'. $img_url .'" alt="'. $author_name .'" /></div>';
										}
										// Content
										$output .= $post_content;
										// Author name
										if ( $author_name && $display_author_name == 'yes' ) {
											$output .= '<div class="vcex-testimonials-fullslider-author"><span>-</span>'. $author_name .'</div>';
										}
									$output .= '</article><!-- .vcex-testimonials-fullslider-entry -->';
								$output .= '</li>';
							}
						
						// End foreach loop
						endforeach;
					
					$output .= '</ul>';
			
				$output .= '</div>';
			
			// Close main wrap
			$output .= '</div><!-- .vcex-testimonials-fullslider --><div class="vcex-clear-floats"></div>';
		
		endif; // End has posts check
				
		// Set things back to normal
		$vcex_testimonials_query = NULL;
		wp_reset_postdata();

		// Return data
		return $output;
		
		
	}
}
add_shortcode('vcex_testimonials_slider', 'vcex_testimonials_slider_shortcode');


/**
	Extend Visual Composer
**/
vc_map( array(
	"name"					=> __( "Testimonials Slider", 'vcex' ),
	"description"			=> __( "Recent testimonials slider", 'vcex' ),
	"base"					=> "vcex_testimonials_slider",
	"class"					=> "",
	"category"				=> array(__("Testimonials","vcex"),__("Sliders","vcex")),
	'admin_enqueue_js'		=> "",
	'admin_enqueue_css'		=> "",
	"icon"					=> "icon-wpb-vcex-testimonials_slider",
	"params"				=> array(
		array(
			"type"			=> "dropdown",
			"heading"		=> __("CSS Animation", "vcex"),
			"param_name"	=> "css_animation",
			"value"			=> array(
				__("No", "vcex")				=> '',
				__("Top to bottom", "vcex")		=> "top-to-bottom",
				__("Bottom to top", "vcex")		=> "bottom-to-top",
				__("Left to right", "vcex")		=> "left-to-right",
				__("Right to left", "vcex")		=> "right-to-left"),
			"description"	=> __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "vcex")
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Style", "vcex"),
			"param_name"	=> "skin",
			"value"			=> array(
				__("Black Text", "vcex")	=> "dark",
				__("White Text", "vcex")	=> "light",
			),
			"description"	=> __( "Select a color scheme.", 'vcex' ),
		),
		array(
			"type"			=> "colorpicker",
			"class"			=> "",
			"heading"		=> __( "Background Color", 'vcex' ),
			"param_name"	=> "background",
			"value"			=> "",
			"description"	=> __( "Select your custom background color.", 'vcex' ),
		),
		array(
			"type"			=> "attach_image",
			"class"			=> "",
			"heading"		=> __( "Background Image", 'vcex' ),
			"param_name"	=> "background_image",
			"value"			=> "",
			"description"	=> __( "You can upload a custom background image for your testimonials slider.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Background Image Style", "vcex"),
			"param_name"	=> "background_style",
			"value"			=> array(
				__("Stretched", "vcex")	=> 'stretch',
				__("Fixed", "vcex")		=> "fixed",
				__("Parallax", "vcex")	=> "parallax",
				__("Repeat", "vcex")	=> "repeat",
			),
			"dependency" => Array('element'	=> "background_image", 'not_empty' => true ),
			"description"	=> __( "Select your background image style.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Post Count", "vcex" ),
			"param_name"	=> "count",
			"value"			=> "3",
			"description"	=> __("How many testimonials do you wish to show?", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"description"	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"description"	=> sprintf( __( 'Select how to sort retrieved posts. More at %s.', 'vcex' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>' ),
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )			=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")			=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Display Author Name?", "vcex"),
			"param_name"	=> "display_author_name",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "yes",
				__( "No", "vcex" )	=> "no",
			),
			"description"	=> __('Do you wish to display the author name?','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Display Author Avatar?", "vcex"),
			"param_name"	=> "display_author_avatar",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "yes",
				__( "No", "vcex" )	=> "no",
			),
			"description"	=> __('Do you wish to display the author avatar?','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __("Custom Font Size", "vcex"),
			"param_name"	=> "font_size",
			"value"			=> "",
			"description"	=> __( "Enter a custom font size in px or em.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __("Custom Font Weight", "vcex"),
			"param_name"	=> "font_weight",
			"value"			=> "",
			"description"	=> __( "Enter a custom font weight.", 'vcex' ),
		),
	)
) );